/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.distributed.AbstractClientProvider;
import co.cask.tephra.distributed.ElasticPool;
import co.cask.tephra.distributed.TransactionServiceThriftClient;
import com.google.common.base.Throwables;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TException;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledClientProvider
extends AbstractClientProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PooledClientProvider.class);
    private volatile TxClientPool clients;
    private int maxClients;

    public PooledClientProvider(Configuration conf, DiscoveryServiceClient discoveryServiceClient) {
        super(conf, discoveryServiceClient);
    }

    @Override
    public void initialize() throws TException {
        super.initialize();
        this.maxClients = this.configuration.getInt("data.tx.client.count", 5);
        if (this.maxClients < 1) {
            LOG.warn("Configuration of data.tx.client.count is invalid: value is " + this.maxClients + " but must be at least 1. " + "Using 1 as a fallback. ");
            this.maxClients = 1;
        }
        this.clients = new TxClientPool(this.maxClients);
    }

    @Override
    public TransactionServiceThriftClient getClient() throws TException {
        return (TransactionServiceThriftClient)this.getClientPool().obtain();
    }

    @Override
    public void returnClient(TransactionServiceThriftClient client) {
        this.getClientPool().release(client);
    }

    @Override
    public void discardClient(TransactionServiceThriftClient client) {
        this.getClientPool().discard(client);
        client.close();
    }

    public String toString() {
        return "Elastic pool of size " + this.maxClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxClientPool getClientPool() {
        if (this.clients != null) {
            return this.clients;
        }
        PooledClientProvider pooledClientProvider = this;
        synchronized (pooledClientProvider) {
            if (this.clients == null) {
                try {
                    this.initialize();
                }
                catch (TException e) {
                    LOG.error("Failed to initialize Tx client provider", (Throwable)e);
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
        return this.clients;
    }

    class TxClientPool
    extends ElasticPool<TransactionServiceThriftClient, TException> {
        TxClientPool(int sizeLimit) {
            super(sizeLimit);
        }

        @Override
        protected TransactionServiceThriftClient create() throws TException {
            return PooledClientProvider.this.newClient();
        }

        @Override
        protected void destroy(TransactionServiceThriftClient client) {
            client.close();
        }
    }
}

