/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElasticPool<T, E extends Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticPool.class);
    private BlockingQueue<T> elements;
    int size = 0;
    int limit;

    protected abstract T create() throws E;

    protected void destroy(T element) {
    }

    protected void recycle(T element) {
    }

    public ElasticPool(int sizeLimit) {
        this.elements = new ArrayBlockingQueue<T>(sizeLimit);
        this.limit = sizeLimit;
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T obtain() throws E {
        T element = this.getOrCreate();
        while (element == null) {
            ElasticPool elasticPool = this;
            synchronized (elasticPool) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOG.warn("Wait interrupted. Don't know what to do. Ignoring.");
                    continue;
                }
                element = this.getOrCreate();
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T element) {
        ElasticPool elasticPool = this;
        synchronized (elasticPool) {
            this.recycle(element);
            this.elements.add(element);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(T element) {
        ElasticPool elasticPool = this;
        synchronized (elasticPool) {
            this.destroy(element);
            --this.size;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getOrCreate() throws E {
        Object client = this.elements.poll();
        if (client != null) {
            return (T)client;
        }
        ElasticPool elasticPool = this;
        synchronized (elasticPool) {
            if (this.size >= this.limit) {
                return null;
            }
            client = this.create();
            ++this.size;
            return (T)client;
        }
    }
}

