/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.ChangeId;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.io.Writable;

public class TransactionEdit
implements Writable {
    private static final TransactionEditCodec CODEC_V2 = new TransactionEditCodecV2();
    private static final byte V2 = -2;
    private static final TransactionEditCodec CODEC_V1 = new TransactionEditCodecV1();
    private static final byte V1 = -1;
    private long writePointer;
    private long visibilityUpperBound;
    private long commitPointer;
    private long expirationDate;
    private State state;
    private Set<ChangeId> changes = Sets.newHashSet();
    private boolean canCommit;

    public TransactionEdit() {
    }

    private TransactionEdit(long writePointer, long visibilityUpperBound, State state, long expirationDate, Set<ChangeId> changes, long commitPointer, boolean canCommit) {
        this.writePointer = writePointer;
        this.visibilityUpperBound = visibilityUpperBound;
        this.state = state;
        this.expirationDate = expirationDate;
        if (changes != null) {
            this.changes = changes;
        }
        this.commitPointer = commitPointer;
        this.canCommit = canCommit;
    }

    public long getWritePointer() {
        return this.writePointer;
    }

    public long getVisibilityUpperBound() {
        return this.visibilityUpperBound;
    }

    public State getState() {
        return this.state;
    }

    public long getExpiration() {
        return this.expirationDate;
    }

    public Set<ChangeId> getChanges() {
        return this.changes;
    }

    public long getCommitPointer() {
        return this.commitPointer;
    }

    public boolean getCanCommit() {
        return this.canCommit;
    }

    public static TransactionEdit createStarted(long writePointer, long visibilityUpperBound, long expirationDate) {
        return new TransactionEdit(writePointer, visibilityUpperBound, State.INPROGRESS, expirationDate, null, 0L, false);
    }

    public static TransactionEdit createCommitting(long writePointer, Set<ChangeId> changes) {
        return new TransactionEdit(writePointer, 0L, State.COMMITTING, 0L, changes, 0L, false);
    }

    public static TransactionEdit createCommitted(long writePointer, Set<ChangeId> changes, long nextWritePointer, boolean canCommit) {
        return new TransactionEdit(writePointer, 0L, State.COMMITTED, 0L, changes, nextWritePointer, canCommit);
    }

    public static TransactionEdit createAborted(long writePointer) {
        return new TransactionEdit(writePointer, 0L, State.ABORTED, 0L, null, 0L, false);
    }

    public static TransactionEdit createInvalid(long writePointer) {
        return new TransactionEdit(writePointer, 0L, State.INVALID, 0L, null, 0L, false);
    }

    public static TransactionEdit createMoveWatermark(long writePointer) {
        return new TransactionEdit(writePointer, 0L, State.MOVE_WATERMARK, 0L, null, 0L, false);
    }

    public void write(DataOutput out) throws IOException {
        CODEC_V2.encode(this, out);
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (-2 == version) {
            CODEC_V2.decode(this, in);
        } else if (-1 == version) {
            CODEC_V1.decode(this, in);
        } else {
            throw new IOException("Unexpected version for edit: " + version);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TransactionEdit)) {
            return false;
        }
        TransactionEdit other = (TransactionEdit)obj;
        return Objects.equal((Object)this.writePointer, (Object)other.writePointer) && Objects.equal((Object)this.commitPointer, (Object)other.commitPointer) && Objects.equal((Object)this.expirationDate, (Object)other.expirationDate) && Objects.equal((Object)this.visibilityUpperBound, (Object)other.visibilityUpperBound) && Objects.equal((Object)((Object)this.state), (Object)((Object)other.state)) && Objects.equal(this.changes, other.changes) && Objects.equal((Object)this.canCommit, (Object)other.canCommit);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("writePointer", this.writePointer).add("visibilityUpperBound", this.visibilityUpperBound).add("commitPointer", this.commitPointer).add("expiration", this.expirationDate).add("state", (Object)this.state).add("changesSize", this.changes != null ? this.changes.size() : 0).add("canCommit", this.canCommit).toString();
    }

    static class TransactionEditCodecV2
    implements TransactionEditCodec {
        TransactionEditCodecV2() {
        }

        @Override
        public void decode(TransactionEdit dest, DataInput in) throws IOException {
            if (dest.changes == null) {
                dest.changes = Sets.newHashSet();
            } else {
                dest.changes.clear();
            }
            dest.writePointer = in.readLong();
            int stateIdx = in.readInt();
            try {
                dest.state = State.values()[stateIdx];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("State enum ordinal value is out of range: " + stateIdx);
            }
            dest.expirationDate = in.readLong();
            dest.commitPointer = in.readLong();
            dest.canCommit = in.readBoolean();
            int changeSize = in.readInt();
            for (int i = 0; i < changeSize; ++i) {
                int currentLength = in.readInt();
                byte[] currentBytes = new byte[currentLength];
                in.readFully(currentBytes);
                dest.changes.add(new ChangeId(currentBytes));
            }
            dest.visibilityUpperBound = in.readLong();
        }

        @Override
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            out.writeByte(-2);
            out.writeLong(src.writePointer);
            out.writeInt(src.state.ordinal());
            out.writeLong(src.expirationDate);
            out.writeLong(src.commitPointer);
            out.writeBoolean(src.canCommit);
            if (src.changes == null) {
                out.writeInt(0);
            } else {
                out.writeInt(src.changes.size());
                for (ChangeId c : src.changes) {
                    byte[] cKey = c.getKey();
                    out.writeInt(cKey.length);
                    out.write(cKey);
                }
            }
            out.writeLong(src.visibilityUpperBound);
        }
    }

    static class TransactionEditCodecV1
    implements TransactionEditCodec {
        TransactionEditCodecV1() {
        }

        @Override
        public void decode(TransactionEdit src, DataInput in) throws IOException {
            if (src.changes == null) {
                src.changes = Sets.newHashSet();
            } else {
                src.changes.clear();
            }
            src.writePointer = in.readLong();
            src.visibilityUpperBound = 0L;
            int stateIdx = in.readInt();
            try {
                src.state = State.values()[stateIdx];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("State enum ordinal value is out of range: " + stateIdx);
            }
            src.expirationDate = in.readLong();
            src.commitPointer = in.readLong();
            src.canCommit = in.readBoolean();
            int changeSize = in.readInt();
            for (int i = 0; i < changeSize; ++i) {
                int currentLength = in.readInt();
                byte[] currentBytes = new byte[currentLength];
                in.readFully(currentBytes);
                src.changes.add(new ChangeId(currentBytes));
            }
        }

        @Override
        @Deprecated
        public void encode(TransactionEdit src, DataOutput out) throws IOException {
            out.writeByte(-1);
            out.writeLong(src.writePointer);
            out.writeInt(src.state.ordinal());
            out.writeLong(src.expirationDate);
            out.writeLong(src.commitPointer);
            out.writeBoolean(src.canCommit);
            if (src.changes == null) {
                out.writeInt(0);
            } else {
                out.writeInt(src.changes.size());
                for (ChangeId c : src.changes) {
                    byte[] cKey = c.getKey();
                    out.writeInt(cKey.length);
                    out.write(cKey);
                }
            }
        }
    }

    private static interface TransactionEditCodec {
        public void decode(TransactionEdit var1, DataInput var2) throws IOException;

        public void encode(TransactionEdit var1, DataOutput var2) throws IOException;
    }

    public static enum State {
        INPROGRESS,
        COMMITTING,
        COMMITTED,
        INVALID,
        ABORTED,
        MOVE_WATERMARK;

    }
}

