/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.distributed.TransactionService;
import co.cask.tephra.runtime.ConfigModule;
import co.cask.tephra.runtime.DiscoveryModules;
import co.cask.tephra.runtime.TransactionClientModule;
import co.cask.tephra.runtime.TransactionModules;
import co.cask.tephra.runtime.ZKModule;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.twill.common.Services;
import org.apache.twill.zookeeper.ZKClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionServiceMain {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionServiceMain.class);
    private Configuration conf;
    private TransactionService txService;

    public static void main(String[] args) throws Exception {
        TransactionServiceMain instance = new TransactionServiceMain();
        instance.doMain(args);
    }

    public TransactionServiceMain() {
        this(null);
    }

    public TransactionServiceMain(Configuration conf) {
        this.conf = conf;
    }

    public void doMain(String[] args) throws Exception {
        final CountDownLatch shutdownLatch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        TransactionServiceMain.this.stop();
                    }
                    finally {
                        try {
                            TransactionServiceMain.this.destroy();
                        }
                        finally {
                            shutdownLatch.countDown();
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.error("Exception when shutting down: " + t.getMessage(), t);
                }
            }
        });
        this.init(args);
        this.start();
        shutdownLatch.await();
    }

    public void init(String[] args) {
        if (this.conf == null) {
            this.conf = HBaseConfiguration.create();
        }
    }

    public void start() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(this.conf), new ZKModule(), new DiscoveryModules().getDistributedModules(), new TransactionModules().getDistributedModules(), new TransactionClientModule()});
        ZKClientService zkClientService = (ZKClientService)injector.getInstance(ZKClientService.class);
        zkClientService.startAndWait();
        this.txService = (TransactionService)((Object)injector.getInstance(TransactionService.class));
        ListenableFuture future = Services.getCompletionFuture((Service)this.txService);
        try {
            this.txService.start();
        }
        catch (Exception e) {
            System.err.println("Failed to start service: " + e.getMessage());
        }
        future.get();
    }

    public void stop() {
        if (this.txService == null) {
            return;
        }
        try {
            if (this.txService.isRunning()) {
                this.txService.stopAndWait();
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to shutdown transaction service.", e);
            System.err.println("Failed to shutdown transaction service: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public void destroy() {
    }
}

