/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionAware;
import co.cask.tephra.TransactionConflictException;
import co.cask.tephra.TransactionFailureException;
import co.cask.tephra.TransactionNotInProgressException;
import co.cask.tephra.TransactionSystemClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContext.class);
    private final Collection<TransactionAware> txAwares;
    private final TransactionSystemClient txClient;
    private Transaction currentTx;

    public TransactionContext(TransactionSystemClient txClient, TransactionAware ... txAwares) {
        this(txClient, (Iterable<TransactionAware>)ImmutableList.copyOf((Object[])txAwares));
    }

    public TransactionContext(TransactionSystemClient txClient, Iterable<TransactionAware> txAwares) {
        this.txAwares = Lists.newArrayList(txAwares);
        this.txClient = txClient;
    }

    public void addTransactionAware(TransactionAware txAware) {
        this.txAwares.add(txAware);
        if (this.currentTx != null) {
            txAware.startTx(this.currentTx);
        }
    }

    public void start() throws TransactionFailureException {
        this.currentTx = this.txClient.startShort();
        for (TransactionAware txAware : this.txAwares) {
            try {
                txAware.startTx(this.currentTx);
            }
            catch (Throwable e) {
                String message = String.format("Unable to start transaction-aware '%s' for transaction %d. ", txAware.getTransactionAwareName(), this.currentTx.getWritePointer());
                LOG.warn(message, e);
                this.txClient.abort(this.currentTx);
                throw new TransactionFailureException(message, e);
            }
        }
    }

    public void finish() throws TransactionFailureException {
        Preconditions.checkState((this.currentTx != null ? 1 : 0) != 0, (Object)"Cannot finish tx that has not been started");
        this.checkForConflicts();
        this.persist();
        this.commit();
        this.postCommit();
        this.currentTx = null;
    }

    public void abort() throws TransactionFailureException {
        this.abort(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(TransactionFailureException cause) throws TransactionFailureException {
        if (this.currentTx == null) {
            return;
        }
        try {
            boolean success = true;
            for (TransactionAware txAware : this.txAwares) {
                try {
                    if (txAware.rollbackTx()) continue;
                    success = false;
                }
                catch (Throwable e) {
                    String message = String.format("Unable to roll back changes in transaction-aware '%s' for transaction %d. ", txAware.getTransactionAwareName(), this.currentTx.getWritePointer());
                    LOG.warn(message, e);
                    if (cause == null) {
                        cause = new TransactionFailureException(message, e);
                    }
                    success = false;
                }
            }
            if (success) {
                this.txClient.abort(this.currentTx);
            } else {
                this.txClient.invalidate(this.currentTx.getWritePointer());
            }
            if (cause != null) {
                throw cause;
            }
        }
        finally {
            this.currentTx = null;
        }
    }

    private void checkForConflicts() throws TransactionFailureException {
        ArrayList changes = Lists.newArrayList();
        for (TransactionAware txAware : this.txAwares) {
            try {
                changes.addAll(txAware.getTxChanges());
            }
            catch (Throwable e) {
                String message = String.format("Unable to retrieve changes from transaction-aware '%s' for transaction %d. ", txAware.getTransactionAwareName(), this.currentTx.getWritePointer());
                LOG.warn(message, e);
                this.abort(new TransactionFailureException(message, e));
            }
        }
        boolean canCommit = false;
        try {
            canCommit = this.txClient.canCommit(this.currentTx, changes);
        }
        catch (TransactionNotInProgressException e) {
            String message = String.format("Transaction %d is not in progress.", this.currentTx.getWritePointer());
            LOG.warn(message, (Throwable)e);
            this.abort(new TransactionFailureException(message, e));
        }
        catch (Throwable e) {
            String message = String.format("Exception from canCommit for transaction %d.", this.currentTx.getWritePointer());
            LOG.warn(message, e);
            this.abort(new TransactionFailureException(message, e));
        }
        if (!canCommit) {
            String message = String.format("Conflict detected for transaction %d.", this.currentTx.getWritePointer());
            this.abort(new TransactionConflictException(message));
        }
    }

    private void persist() throws TransactionFailureException {
        for (TransactionAware txAware : this.txAwares) {
            boolean success;
            Throwable cause = null;
            try {
                success = txAware.commitTx();
            }
            catch (Throwable e) {
                success = false;
                cause = e;
            }
            if (success) continue;
            String message = String.format("Unable to persist changes of transaction-aware '%s' for transaction %d. ", txAware.getTransactionAwareName(), this.currentTx.getWritePointer());
            if (cause == null) {
                LOG.warn(message);
            } else {
                LOG.warn(message, cause);
            }
            this.abort(new TransactionFailureException(message, cause));
        }
    }

    private void commit() throws TransactionFailureException {
        boolean commitSuccess = false;
        try {
            commitSuccess = this.txClient.commit(this.currentTx);
        }
        catch (TransactionNotInProgressException e) {
            String message = String.format("Transaction %d is not in progress.", this.currentTx.getWritePointer());
            LOG.warn(message, (Throwable)e);
            this.abort(new TransactionFailureException(message, e));
        }
        catch (Throwable e) {
            String message = String.format("Exception from commit for transaction %d.", this.currentTx.getWritePointer());
            LOG.warn(message, e);
            this.abort(new TransactionFailureException(message, e));
        }
        if (!commitSuccess) {
            String message = String.format("Conflict detected for transaction %d.", this.currentTx.getWritePointer());
            this.abort(new TransactionConflictException(message));
        }
    }

    private void postCommit() throws TransactionFailureException {
        TransactionFailureException cause = null;
        for (TransactionAware txAware : this.txAwares) {
            try {
                txAware.postTxCommit();
            }
            catch (Throwable e) {
                String message = String.format("Unable to perform post-commit in transaction-aware '%s' for transaction %d. ", txAware.getTransactionAwareName(), this.currentTx.getWritePointer());
                LOG.warn(message, e);
                cause = new TransactionFailureException(message, e);
            }
        }
        if (cause != null) {
            throw cause;
        }
    }
}

