package co.britehealth.android.util;

import android.util.Base64;

import com.squareup.okhttp.OkHttpClient;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;


public class NetworkUtils {

    public static final String ENDPOINT_BASE = "https://api.britehealth.co";

    public static final String BRITE_HEALTH_HEADER = "BH-Signature";
    public static final String STATUS_CODE = "status_code";
    public static final String ERROR_MESSAGE = "error_message";

    private static final int CONNECT_TIMEOUT = 10; // in seconds
    private static final int READ_TIMEOUT = 10; // in seconds

    private static OkHttpClient sHttpClient;

    public static OkHttpClient getHttpClient() {

        if (sHttpClient == null) {

            synchronized (NetworkUtils.class) {

                if (sHttpClient == null) {

                    sHttpClient = new OkHttpClient();
                    sHttpClient.setConnectTimeout(CONNECT_TIMEOUT, TimeUnit.SECONDS);
                    sHttpClient.setReadTimeout(READ_TIMEOUT, TimeUnit.SECONDS);

                }

            }

        }

        return sHttpClient;

    }

    public static String generateSignature(String query, String secret) {

        final String HASH_ALGORITHM = "HmacSHA256";

        Key key = new SecretKeySpec(secret.getBytes(), HASH_ALGORITHM);
        String hash = null;

        try {

            Mac mac = Mac.getInstance(key.getAlgorithm());
            mac.init(key);
            byte[] hmac = mac.doFinal(query.getBytes());
            hash = Base64.encodeToString(hmac, Base64.DEFAULT);

        } catch (NoSuchAlgorithmException | InvalidKeyException e) {
            e.printStackTrace();
        }

        return hash;

    }

    public static String md5(String s) {

        char[] hexTable = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        MessageDigest digest;

        try {

            digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes(), 0, s.length());
            byte[] bytes = digest.digest();

            String hash = "";
            for (byte aByte : bytes) {
                int di = (aByte + 256) & 0xFF;
                hash = hash + hexTable[(di >> 4) & 0xF] + hexTable[di & 0xF];
            }

            return hash;

        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }

        return "";

    }

}
