package co.britehealth.android.service;

import android.app.IntentService;
import android.content.Intent;
import android.database.Cursor;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;

import java.io.IOException;
import java.util.List;

import co.britehealth.android.BriteHealthSdk;
import co.britehealth.android.FitnessActivity;
import co.britehealth.android.model.data.DBContract;
import co.britehealth.android.util.NetworkUtils;


public class UserFitnessActivityService extends IntentService {

    private static final String TAG = UserFitnessActivityService.class.getSimpleName();

    public static final String ACTION = "user_fitness_activity_action";
    public static final String SUCCESSFUL = "successful";

    private Gson mGson;
    private OkHttpClient mHttpClient;

    public UserFitnessActivityService() {

        super(TAG);

        mGson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        mHttpClient = NetworkUtils.getHttpClient();

    }

    @Override
    protected void onHandleIntent(Intent intent) {

        Intent broadcastIntent = new Intent(ACTION);

        String apiKey = intent.getStringExtra(BriteHealthSdk.EXTRA_API_KEY);
        String secret = intent.getStringExtra(BriteHealthSdk.EXTRA_DATA_SECRET);
        List<FitnessActivity> fitnessActivities =
                intent.getParcelableArrayListExtra(BriteHealthSdk.EXTRA_USER_FITNESS_ACTIVITY);

        String endpointUrl = NetworkUtils.ENDPOINT_BASE + "/userhealth/datapoint?api_key=" + apiKey;

        Cursor cursor = getContentResolver().query(
                DBContract.BriteHealthUserTable.CONTENT_URI,
                new String[]{DBContract.BriteHealthUserTable._ID},
                null,
                null,
                null
        );

        if (cursor.moveToFirst()) {

            for (FitnessActivity activity : fitnessActivities) {

                activity.setUserId(
                        cursor.getInt(cursor.getColumnIndex(DBContract.BriteHealthUserTable._ID))
                );

            }

            final MediaType JSON = MediaType.parse("application/json; charset=utf-8");

            String signature = NetworkUtils.generateSignature(apiKey + mGson.toJson(fitnessActivities), secret);
            RequestBody requestBody = RequestBody.create(JSON, mGson.toJson(fitnessActivities));

            Log.d("BriteHealthSdk", mGson.toJson(fitnessActivities));

            Request request = new Request.Builder()
                    .url(endpointUrl)
                    .addHeader(NetworkUtils.BRITE_HEALTH_HEADER, signature)
                    .put(requestBody)
                    .build();

            try {

                Response response = mHttpClient.newCall(request).execute();

                if(response.isSuccessful()) {

                    broadcastIntent.putExtra(SUCCESSFUL, true);

                } else {

                    UnsuccessfulResponse unsuccessfulResponse = mGson.fromJson(
                            response.body().string(),
                            UnsuccessfulResponse.class
                    );

                    broadcastIntent.putExtra(SUCCESSFUL, false);
                    broadcastIntent.putExtra(NetworkUtils.STATUS_CODE, unsuccessfulResponse.statusCode);
                    broadcastIntent.putExtra(NetworkUtils.ERROR_MESSAGE, unsuccessfulResponse.errorMessage);

                }

            } catch (IOException e) {

                e.printStackTrace();

            }

        } else {

            broadcastIntent.putExtra(SUCCESSFUL, false);
            broadcastIntent.putExtra(NetworkUtils.ERROR_MESSAGE, "You need to register first.");

        }

        LocalBroadcastManager
                .getInstance(this)
                .sendBroadcast(broadcastIntent);

        cursor.close();

    }

    private class UnsuccessfulResponse {

        @SerializedName("status_code")
        private int statusCode;

        @SerializedName("error_message")
        private String errorMessage;

    }

}
