package co.britehealth.android.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;

import org.apache.commons.math3.distribution.NormalDistribution;

import java.io.IOException;

import co.britehealth.android.BriteHealthSdk;
import co.britehealth.android.assessment.tmt.TestManager;
import co.britehealth.android.model.data.DBContract;
import co.britehealth.android.util.DatabaseUtils;
import co.britehealth.android.util.NetworkUtils;


public class ComparativeAnalyticsService extends IntentService {

    private static final String TAG = ComparativeAnalyticsService.class.getSimpleName();

    public static final String ACTION = "comparative_analytics_action";
    public static final String SUCCESSFUL = "successful";
    public static final String PERCENTILES = "percentiles";

    private Gson mGson;
    private OkHttpClient mHttpClient;

    public ComparativeAnalyticsService() {

        super(TAG);

        mGson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        mHttpClient = NetworkUtils.getHttpClient();

    }

    @Override
    protected void onHandleIntent(Intent intent) {

        String apiKey = intent.getStringExtra(BriteHealthSdk.EXTRA_API_KEY);
        String secret = intent.getStringExtra(BriteHealthSdk.EXTRA_DATA_SECRET);

        int userId = DatabaseUtils.getCurrentUserId(this);

        String endpointUrl = NetworkUtils.ENDPOINT_BASE + "/assessment/comparativeAnalytics?" +
                "user_id=" + userId +
                "&api_key=" + apiKey;

        String signature = NetworkUtils.generateSignature(apiKey + userId, secret);

        Request request = new Request.Builder()
                .url(endpointUrl)
                .addHeader(NetworkUtils.BRITE_HEALTH_HEADER, signature)
                .build();

        try {

            Response response = mHttpClient.newCall(request).execute();
            Intent broadcastIntent = new Intent(ACTION);

            if (response.isSuccessful()) {

                AnalyticsResponse[] analyticsResponses
                        = mGson.fromJson(response.body().string(), AnalyticsResponse[].class);

                NormalDistribution normalDistribution;

                Bundle bundle = new Bundle();

                int[] scores = computeTotalScore();

                for (AnalyticsResponse analyticsResponse : analyticsResponses) {

                    if (analyticsResponse.getScoreType().equals("TOTAL")) {

                        if (analyticsResponse.getAgeRange().equals("ALL")) {

                            if (analyticsResponse.getGender().equals("ALL")) {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("one",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[0]) * 100));

                            } else {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("three",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[0]) * 100));

                            }

                        } else {

                            if (analyticsResponse.getGender().equals("ALL")) {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("two",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[0]) * 100));

                            } else {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("four",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[0]) * 100));

                            }

                        }

                    }

                    if (analyticsResponse.getScoreType().equals("EXECUTIVE FUNCTIONS")) {

                        if (analyticsResponse.getAgeRange().equals("ALL")) {

                            if (analyticsResponse.getGender().equals("ALL")) {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("five",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[1]) * 100));

                            } else {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("seven",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[1]) * 100));

                            }

                        } else {

                            if (analyticsResponse.getGender().equals("ALL")) {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("six",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[1]) * 100));

                            } else {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("eight",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[1]) * 100));

                            }

                        }

                    }

                    if (analyticsResponse.getScoreType().equals("MEMORY")) {

                        if (analyticsResponse.getAgeRange().equals("ALL")) {

                            if (analyticsResponse.getGender().equals("ALL")) {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("nine",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[2]) * 100));

                            } else {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("eleven",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[2]) * 100));

                            }

                        } else {

                            if (analyticsResponse.getGender().equals("ALL")) {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("ten",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[2]) * 100));

                            } else {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("twelve",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[2]) * 100));

                            }

                        }

                    }

                    if (analyticsResponse.getScoreType().equals("PROCESSING SPEED")) {

                        if (analyticsResponse.getAgeRange().equals("ALL")) {

                            if (analyticsResponse.getGender().equals("ALL")) {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("thirteen",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[3]) * 100));

                            } else {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("fifteen",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[3]) * 100));

                            }

                        } else {

                            if (analyticsResponse.getGender().equals("ALL")) {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("fourteen",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[3]) * 100));

                            } else {

                                normalDistribution = new NormalDistribution(
                                        analyticsResponse.getMean(),
                                        analyticsResponse.getStandardDeviation()
                                );

                                bundle.putInt("sixteen",
                                        (int) Math.round(normalDistribution.cumulativeProbability(scores[3]) * 100));

                            }

                        }

                    }

                }

                broadcastIntent.putExtra(PERCENTILES, bundle);
                broadcastIntent.putExtra(SUCCESSFUL, true);

            } else {

                UnsuccessfulResponse unsuccessfulResponse = mGson.fromJson(
                        response.body().string(),
                        UnsuccessfulResponse.class
                );

                broadcastIntent.putExtra(SUCCESSFUL, false);
                broadcastIntent.putExtra(NetworkUtils.STATUS_CODE, unsuccessfulResponse.statusCode);
                broadcastIntent.putExtra(NetworkUtils.ERROR_MESSAGE, unsuccessfulResponse.errorMessage);

            }

            LocalBroadcastManager
                    .getInstance(this)
                    .sendBroadcast(broadcastIntent);

        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    private int[] computeTotalScore() {

        int[] returnInts = new int[4];

        int totalScore = 0;

        Cursor cursor = getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"1"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );


        int lastScore1 = 0;

        if (cursor.moveToFirst()) {

            lastScore1 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        totalScore = totalScore + lastScore1;

        cursor = getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"2"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );

        int lastScore2 = 0;

        if (cursor.moveToFirst()) {

            lastScore2 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        totalScore = totalScore + lastScore2;

        cursor = getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"3"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );

        int lastScore3 = 0;

        if (cursor.moveToFirst()) {

            lastScore3 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        totalScore = totalScore + lastScore3;

        cursor = getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"4"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );

        int lastScore4 = 0;

        if (cursor.moveToFirst()) {

            lastScore4 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        totalScore = totalScore + lastScore4;

        cursor = getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"5"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );

        int lastScore5 = 0;

        if (cursor.moveToFirst()) {

            lastScore5 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        totalScore = totalScore + lastScore5;

        cursor.close();

        totalScore = totalScore / 5;

        returnInts[0] = totalScore;
        returnInts[1] = (lastScore1 + lastScore2) / 2;
        returnInts[2] = (lastScore3 + lastScore5) / 2;

        float tmtA = getSharedPreferences(TestManager.TMT_A_SCORE, Context.MODE_PRIVATE)
                .getFloat(TestManager.TMT_A_SCORE, 0);

        float score8 = ((3f * lastScore4) + tmtA) / 4f;

        returnInts[3] = (int) score8;

        return returnInts;

    }

    private class AnalyticsResponse {

        @SerializedName("gender")
        private String gender;

        @SerializedName("age_range")
        private String ageRange;

        @SerializedName("mean")
        private double mean;

        @SerializedName("standard_deviation")
        private double standardDeviation;

        @SerializedName("score_type")
        private String scoreType;

        public String getGender() {
            return gender;
        }

        public String getAgeRange() {
            return ageRange;
        }

        public double getMean() {
            return mean;
        }

        public double getStandardDeviation() {
            return standardDeviation;
        }

        public String getScoreType() {
            return scoreType;
        }

    }

    private class UnsuccessfulResponse {

        @SerializedName("status_code")
        private int statusCode;

        @SerializedName("error_message")
        private String errorMessage;

    }

}
