package co.britehealth.android.service;

import android.app.IntentService;
import android.content.Intent;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;

import java.io.IOException;

import co.britehealth.android.BriteHealthSdk;
import co.britehealth.android.assessment.framework.BaseTestModel;
import co.britehealth.android.assessment.stroop.TestModel;
import co.britehealth.android.util.NetworkUtils;


public class AssessmentService extends IntentService {

    private static final String TAG = AssessmentService.class.getSimpleName();

    private Gson mGson;
    private OkHttpClient mHttpClient;

    public AssessmentService() {

        super(TAG);

        mGson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
        mHttpClient = NetworkUtils.getHttpClient();

    }

    @Override
    protected void onHandleIntent(Intent intent) {

        BaseTestModel baseTestModel = intent.getParcelableExtra(BaseTestModel.EXTRA);
        String apiKey = intent.getStringExtra(BriteHealthSdk.EXTRA_API_KEY);
        String secret = intent.getStringExtra(BriteHealthSdk.EXTRA_DATA_SECRET);

        switch (baseTestModel.getType()) {

            case TestModel.TYPE: {

                TestModel testModel = (TestModel) baseTestModel;

                String endpointUrl = NetworkUtils.ENDPOINT_BASE + "/assessment/stroop?api_key=" + apiKey;

                final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
                String signature = NetworkUtils.generateSignature(apiKey + mGson.toJson(testModel), secret);

                RequestBody requestBody = RequestBody.create(JSON, mGson.toJson(testModel));

                Request request = new Request.Builder()
                        .url(endpointUrl)
                        .addHeader(NetworkUtils.BRITE_HEALTH_HEADER, signature)
                        .post(requestBody)
                        .build();

                try {

                    Response response = mHttpClient.newCall(request).execute();

                } catch (IOException e) {
                    e.printStackTrace();
                }

                break;

            }

            case co.britehealth.android.assessment.tmt.TestModel.TYPE:{

                co.britehealth.android.assessment.tmt.TestModel testModel =
                        (co.britehealth.android.assessment.tmt.TestModel) baseTestModel;

                String endpointUrl = NetworkUtils.ENDPOINT_BASE + "/assessment/trailMaking?api_key=" + apiKey;

                final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
                String signature = NetworkUtils.generateSignature(apiKey + mGson.toJson(testModel), secret);

                RequestBody requestBody = RequestBody.create(JSON, mGson.toJson(testModel));

                Request request = new Request.Builder()
                        .url(endpointUrl)
                        .addHeader(NetworkUtils.BRITE_HEALTH_HEADER, signature)
                        .post(requestBody)
                        .build();

                try {

                    Response response = mHttpClient.newCall(request).execute();

                } catch (IOException e) {
                    e.printStackTrace();
                }

                break;

            }

            case co.britehealth.android.assessment.shape.recall.TestModel.TYPE:{

                co.britehealth.android.assessment.shape.recall.TestModel testModel =
                        (co.britehealth.android.assessment.shape.recall.TestModel) baseTestModel;

                String endpointUrl = NetworkUtils.ENDPOINT_BASE + "/assessment/shapeRecall?api_key=" + apiKey;

                final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
                String signature = NetworkUtils.generateSignature(apiKey + mGson.toJson(testModel), secret);

                RequestBody requestBody = RequestBody.create(JSON, mGson.toJson(testModel));

                Request request = new Request.Builder()
                        .url(endpointUrl)
                        .addHeader(NetworkUtils.BRITE_HEALTH_HEADER, signature)
                        .post(requestBody)
                        .build();

                try {

                    Response response = mHttpClient.newCall(request).execute();

                } catch (IOException e) {
                    e.printStackTrace();
                }

                break;
            }

            case co.britehealth.android.assessment.dsst.TestModel.TYPE: {

                co.britehealth.android.assessment.dsst.TestModel testModel =
                        (co.britehealth.android.assessment.dsst.TestModel) baseTestModel;

                String endpointUrl = NetworkUtils.ENDPOINT_BASE + "/assessment/dsst?api_key=" + apiKey;

                final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
                String signature = NetworkUtils.generateSignature(apiKey + mGson.toJson(testModel), secret);

                RequestBody requestBody = RequestBody.create(JSON, mGson.toJson(testModel));

                Request request = new Request.Builder()
                        .url(endpointUrl)
                        .addHeader(NetworkUtils.BRITE_HEALTH_HEADER, signature)
                        .post(requestBody)
                        .build();

                try {

                    Response response = mHttpClient.newCall(request).execute();

                } catch (IOException e) {
                    e.printStackTrace();
                }

                break;

            }

            case co.britehealth.android.assessment.dissimilar.shapes.TestModel.TYPE: {

                co.britehealth.android.assessment.dissimilar.shapes.TestModel testModel =
                        (co.britehealth.android.assessment.dissimilar.shapes.TestModel) baseTestModel;

                String endpointUrl = NetworkUtils.ENDPOINT_BASE + "/assessment/dissimilarShapes?api_key=" + apiKey;

                final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
                String signature = NetworkUtils.generateSignature(apiKey + mGson.toJson(testModel), secret);

                RequestBody requestBody = RequestBody.create(JSON, mGson.toJson(testModel));

                Request request = new Request.Builder()
                        .url(endpointUrl)
                        .addHeader(NetworkUtils.BRITE_HEALTH_HEADER, signature)
                        .post(requestBody)
                        .build();

                try {

                    Response response = mHttpClient.newCall(request).execute();

                } catch (IOException e) {
                    e.printStackTrace();
                }

                break;

            }

        }

    }

}
