package co.britehealth.android.model.data;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;


public class Provider extends ContentProvider {

    private static final int BRITE_HEALTH_USER = 1;
    private static final int NEXT_ASSESSMENT_TIMES = 2;

    private static final UriMatcher myURIMatcher = buildUriMatcher();
    private DBHelper dbHelper;

    private static UriMatcher buildUriMatcher() {

        final UriMatcher matcher = new UriMatcher(UriMatcher.NO_MATCH);
        final String contentAuthority = DBContract.CONTENT_AUTHORITY;

        matcher.addURI(contentAuthority, DBContract.PATH_BRITE_HEALTH_USER, BRITE_HEALTH_USER);
        matcher.addURI(contentAuthority, DBContract.PATH_NEXT_ASSESSMENT_TIMES, NEXT_ASSESSMENT_TIMES);

        return matcher;

    }

    @Override
    public boolean onCreate() {
        dbHelper = new DBHelper(getContext());
        return true;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {

        int match = myURIMatcher.match(uri);
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor returnCursor;

        switch (match) {
            case BRITE_HEALTH_USER: {
                returnCursor = db.query(
                        DBContract.BriteHealthUserTable.TABLE_NAME,
                        projection,
                        selection,
                        selectionArgs,
                        null,
                        null,
                        sortOrder
                );
                break;
            }
            case NEXT_ASSESSMENT_TIMES: {
                returnCursor = db.query(
                        DBContract.NextAssessmentTimesTable.TABLE_NAME,
                        projection,
                        selection,
                        selectionArgs,
                        null,
                        null,
                        sortOrder
                );
                break;
            }
            default:
                throw new UnsupportedOperationException("Unknown URI: " + uri);
        }

        if (returnCursor != null) {
            returnCursor.setNotificationUri(getContext().getContentResolver(), uri);
        }

        return returnCursor;

    }

    @Override
    public String getType(Uri uri) {
        return null;
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {

        int match = myURIMatcher.match(uri);
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Uri returnURI;

        switch (match) {
            case BRITE_HEALTH_USER: {
                long _id = db.insert(DBContract.BriteHealthUserTable.TABLE_NAME, null, values);
                if (_id > 0) {
                    returnURI = DBContract.BriteHealthUserTable.buildBriteHealthUserUri(_id);
                } else {
                    throw new android.database.SQLException("Failed to insert a row into " + uri);
                }
                break;
            }
            case NEXT_ASSESSMENT_TIMES: {
                long _id = db.insert(DBContract.NextAssessmentTimesTable.TABLE_NAME, null, values);
                if (_id > 0) {
                    returnURI = DBContract.NextAssessmentTimesTable.buildNextAssessmentTimesUri(_id);
                } else {
                    throw new android.database.SQLException("Failed to insert a row into " + uri);
                }
                break;
            }
            default:
                throw new UnsupportedOperationException("Unknown URI: " + uri);
        }

        getContext().getContentResolver().notifyChange(uri, null);

        return returnURI;

    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {

        int match = myURIMatcher.match(uri);
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        int rowsDeleted;

        if (selection == null) {
            selection = "1";
        }

        switch (match) {
            case BRITE_HEALTH_USER: {
                rowsDeleted = db.delete(DBContract.BriteHealthUserTable.TABLE_NAME, selection, selectionArgs);
                break;
            }
            case NEXT_ASSESSMENT_TIMES: {
                rowsDeleted = db.delete(DBContract.NextAssessmentTimesTable.TABLE_NAME, selection, selectionArgs);
                break;
            }
            default:
                throw new UnsupportedOperationException("Unknown URI: " + uri);
        }

        if (rowsDeleted != 0) {
            getContext().getContentResolver().notifyChange(uri, null);
        }

        return rowsDeleted;

    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {

        int match = myURIMatcher.match(uri);
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        int rowsUpdated;

        switch (match) {
            case BRITE_HEALTH_USER: {
                rowsUpdated = db.update(
                        DBContract.BriteHealthUserTable.TABLE_NAME,
                        values,
                        selection,
                        selectionArgs
                );
                break;
            }
            case NEXT_ASSESSMENT_TIMES: {
                rowsUpdated = db.update(
                        DBContract.NextAssessmentTimesTable.TABLE_NAME,
                        values,
                        selection,
                        selectionArgs
                );
                break;
            }
            default:
                throw new UnsupportedOperationException("Unknown URI: " + uri);
        }

        if (rowsUpdated != 0) {
            getContext().getContentResolver().notifyChange(uri, null);
        }

        return rowsUpdated;

    }

}
