package co.britehealth.android.model.data;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import co.britehealth.android.model.data.DBContract.BriteHealthUserTable;
import co.britehealth.android.model.data.DBContract.NextAssessmentTimesTable;


public class DBHelper extends SQLiteOpenHelper {

    private static final String DATABASE_NAME = "britehealth.db";
    private static final int DATABASE_VERSION = 1;

    public DBHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {

        final String SQL_CREATE_BRITE_HEALTH_USER_TABLE = "CREATE TABLE " + BriteHealthUserTable.TABLE_NAME + " (" +
                BriteHealthUserTable._ID + " INTEGER NOT NULL, " +
                BriteHealthUserTable.COLUMN_EMAIL + " TEXT, " +
                BriteHealthUserTable.COLUMN_EMAIL_MD5 + " TEXT NOT NULL, " +
                BriteHealthUserTable.COLUMN_GENDER + " INTEGER, " +
                BriteHealthUserTable.COLUMN_DATE_OF_BIRTH + " INTEGER, " +
                BriteHealthUserTable.COLUMN_AGE + " INTEGER, " +
                BriteHealthUserTable.COLUMN_IMAGE_URL + " TEXT" +
                ");";

        final String SQL_CREATE_NEXT_ASSESSMENT_TIMES_TABLE = "CREATE TABLE " + NextAssessmentTimesTable.TABLE_NAME + " (" +
                NextAssessmentTimesTable._ID + " INTEGER NOT NULL, " +
                NextAssessmentTimesTable.COLUMN_SCORE + " INTEGER, " +
                NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME + " INTEGER" +
                ");";

        db.execSQL(SQL_CREATE_BRITE_HEALTH_USER_TABLE);
        db.execSQL(SQL_CREATE_NEXT_ASSESSMENT_TIMES_TABLE);

    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

        db.execSQL("DROP TABLE IF EXISTS " + BriteHealthUserTable.TABLE_NAME);
        db.execSQL("DROP TABLE IF EXISTS " + NextAssessmentTimesTable.TABLE_NAME);
        onCreate(db);

    }

}
