package co.britehealth.android.model.data;

import android.net.Uri;
import android.provider.BaseColumns;


public class DBContract {

    public static final String CONTENT_AUTHORITY = "co.britehealth.android";
    public static final Uri BASE_CONTENT_URI = Uri.parse("content://" + CONTENT_AUTHORITY);

    public static final String PATH_BRITE_HEALTH_USER = "brite_health_user";
    public static final String PATH_NEXT_ASSESSMENT_TIMES = "next_assessment_times";

    public static final class BriteHealthUserTable implements BaseColumns {

        public static final String TABLE_NAME = "brite_health_user";

        public static final String COLUMN_EMAIL = "email";
        public static final String COLUMN_EMAIL_MD5 = "email_md5";
        public static final String COLUMN_GENDER = "gender";
        public static final String COLUMN_DATE_OF_BIRTH = "date_of_birth";
        public static final String COLUMN_AGE = "age";
        public static final String COLUMN_IMAGE_URL = "image_url";

        public static final Uri CONTENT_URI =
                BASE_CONTENT_URI.buildUpon().appendPath(PATH_BRITE_HEALTH_USER).build();

        public static Uri buildBriteHealthUserUri(long id) {
            return CONTENT_URI.buildUpon().appendPath(String.valueOf(id)).build();
        }

    }

    public static final class NextAssessmentTimesTable implements BaseColumns {

        public static final String TABLE_NAME = "next_assessment_times";

        public static final String COLUMN_SCORE = "score";
        public static final String COLUMN_NEXT_ASSESSMENT_TIME = "next_assessment_time";

        public static final Uri CONTENT_URI =
                BASE_CONTENT_URI.buildUpon().appendPath(PATH_NEXT_ASSESSMENT_TIMES).build();

        public static Uri buildNextAssessmentTimesUri(long id) {
            return CONTENT_URI.buildUpon().appendPath(String.valueOf(id)).build();
        }

    }

}
