package co.britehealth.android.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

import java.util.Date;


public class Score implements Parcelable {

    @SerializedName("user_id")
    private int userId;

    private double score;

    @SerializedName("score_type")
    private String scoreType;

    @SerializedName("created_date")
    private Date createdDate;

    public int getUserId() {
        return userId;
    }

    public double getScore() {
        return score;
    }

    public String getScoreType() {
        return scoreType;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Score> CREATOR = new Creator<Score>() {

        @Override
        public Score createFromParcel(Parcel source) {
            return new Score(source);
        }

        @Override
        public Score[] newArray(int size) {
            return new Score[size];
        }
    };

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeInt(userId);
        dest.writeDouble(score);
        dest.writeString(scoreType);
        if (createdDate != null) {
            dest.writeLong(createdDate.getTime());
        }

    }


    public Score(Parcel source) {

        userId = source.readInt();
        score = source.readDouble();
        scoreType = source.readString();
        createdDate = new Date(source.readLong());

    }

}
