package co.britehealth.android.assessment.tmt;

import android.os.Parcel;

import com.google.gson.annotations.SerializedName;

import co.britehealth.android.assessment.framework.BaseTestModel;


public class TestModel extends BaseTestModel {

    public static final int TYPE = 2;

    @SerializedName("num_errors")
    private int mNumErrors;

    @SerializedName("mode")
    private String mMode;

    @SerializedName("last_number")
    private int mLastNumber;

    @SerializedName("processing_time")
    private long mProcessingTime;

    public TestModel(int type) {

        super(type);

        mNumErrors = 0;
        mLastNumber = 1;

    }

    public void setNumErrors(int numErrors) {
        mNumErrors = numErrors;
    }

    public void setMode(String mode) {
        mMode = mode;
    }

    public void setLastNumber(int lastNumber) {
        mLastNumber = lastNumber;
    }

    public void setProcessingTime(long processingTime) {
        mProcessingTime = processingTime;
    }

    public int getNumErrors() {
        return mNumErrors;
    }

    public String getMode() {
        return mMode;
    }

    public int getLastNumber() {
        return mLastNumber;
    }

    public long getProcessingTime() {
        return mProcessingTime;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeInt(getType());
        dest.writeInt(getUserId());
        dest.writeLong(getStartDate().getTime());
        dest.writeLong(getFinishDate().getTime());
        dest.writeDouble(getScore());
        dest.writeInt(mNumErrors);
        dest.writeString(mMode);
        dest.writeInt(mLastNumber);
        dest.writeLong(mProcessingTime);

    }

    public static final Creator<TestModel> CREATOR = new Creator<TestModel>() {

        @Override
        public TestModel createFromParcel(Parcel source) {
            return new TestModel(source);
        }

        @Override
        public TestModel[] newArray(int size) {
            return new TestModel[size];
        }

    };

    protected TestModel(Parcel parcel) {

        super(parcel);
        mNumErrors = parcel.readInt();
        mMode = parcel.readString();
        mLastNumber = parcel.readInt();
        mProcessingTime = parcel.readLong();

    }

}
