package co.britehealth.android.assessment.tmt;

import android.content.Context;

import co.britehealth.android.BriteHealthException;
import co.britehealth.android.assessment.framework.BaseTestManager;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.TestCallbacks;
import co.britehealth.android.util.DatabaseUtils;


public class TestManager extends BaseTestManager {

    public static final String TMT_A_SCORE = "co_britehealth_android_tmt_a_score";

    public static final String TMT_NUM_QUITS = "co_britehealth_android_tmt_num_quits";
    public static final String TMT_NUM_QUITS_KEY = "co_britehealth_android_tmt_num_quits_key";

    private long mSectionAScore;
    private long mSectionBScore;

    protected TestManager(Context context, TestCallbacks testCallbacks) {
        super(context, testCallbacks);
    }

    @Override
    public TestModel getTestModel() {
        return (TestModel) super.getTestModel();
    }

    public void setNumErrors(int numErrors) {
        getTestModel().setNumErrors(numErrors);
    }

    public void setMode(String mode) {
        getTestModel().setMode(mode);
    }

    public void setLastNumber(int lastNumber) {
        getTestModel().setLastNumber(lastNumber);
    }

    public void setProcessingTime(long processingTime) {
        getTestModel().setProcessingTime(processingTime);
    }

    public void setSectionAScore(long sectionAScore) {
        mSectionAScore = sectionAScore;
    }

    public void setSectionBScore(long sectionBScore) {
        mSectionBScore = sectionBScore;
    }

    @Override
    public void createTest() {

        TestModel testModel = new TestModel(TestModel.TYPE);

        int userId = DatabaseUtils.getCurrentUserId(getContext());
        if (userId != -1) {
            testModel.setUserId(userId);
        } else {

            throw new BriteHealthException(
                    "You need to register the current user with Brite Health before creating a test."
            );

        }

        setTestModel(testModel);

        super.createTest();

    }

    @Override
    public BaseTestScores computeBasicTestScores() {

        TestScores testScores = new TestScores();

        if (mSectionAScore == 0) {
            testScores.setScore(0);
        } else {

            double score = 100 - (100 * (Math.log((float) mSectionBScore / (float) mSectionAScore) / Math.log(3)));

            if (score > 100) {
                score = 100;
            } else if (score < 0) {
                score = 0;
            }

            testScores.setScore((int) score);

        }

        return testScores;

    }

}
