package co.britehealth.android.assessment.stroop;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageButton;
import android.widget.TextView;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import co.britehealth.android.R;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.ResponseView;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.BaseTestView;
import co.britehealth.android.model.data.DBContract;


public class TestView extends BaseTestView
        implements
        View.OnClickListener,
        Toolbar.OnMenuItemClickListener {

    private static final String SCREEN_NAME = "Stroop: " + TestView.class.getSimpleName();
    private Tracker mTracker;

    private static final long NEXT_ASSESSMENT_DELAY = 2 * 7 * 24 * 60 * 60 * 1000;

    private TextView mCounterTextView;
    private TextView mTimerTextView;
    private TextView mWordTextView;
    private ResponseView mResponseView;
    private ImageButton mPositiveButton;
    private ImageButton mNegativeButton;
    private long currentTick;

    private boolean mRestarted;

    private AlphaAnimation mAlphaAnimation;

    private TranslateAnimation mTranslateAnimationIntro;
    private TranslateAnimation mTranslateAnimationOutro;

    private CountDownTimer mCountDownTimer;

    private Handler mHandler;
    private Runnable mRunnable;
    private long mStartTime;
    private long mTimeInMilliseconds;
    private long mTimeBuffer;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        BriteHealthAssessmentActivity activity = (BriteHealthAssessmentActivity) getActivity();
        mTracker = activity.getDefaultTracker();

        mRestarted = false;

        setTestManager(
                new TestManager(getActivity(), this)
        );
        getTestManager().createTest();

        mAlphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        mAlphaAnimation.setDuration(333);
        mAlphaAnimation.setRepeatMode(Animation.REVERSE);

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_stroop, container, false);

        Toolbar toolbar = (Toolbar) rootView.findViewById(R.id.co_britehealth_android_toolbar);
        toolbar.inflateMenu(R.menu.co_britehealth_android_test);
        toolbar.setOnMenuItemClickListener(this);

        mCounterTextView = (TextView) toolbar.findViewById(R.id.co_britehealth_android_counter_textView);
        mTimerTextView = (TextView) toolbar.findViewById(R.id.co_britehealth_android_timer_textView);
        mWordTextView = (TextView) rootView.findViewById(R.id.co_britehealth_android_word_textView);
        mPositiveButton = (ImageButton) rootView.findViewById(R.id.co_britehealth_android_positive_button);
        mNegativeButton = (ImageButton) rootView.findViewById(R.id.co_britehealth_android_negative_button);

        mPositiveButton.setOnClickListener(this);
        mNegativeButton.setOnClickListener(this);

        mResponseView = (ResponseView) rootView.findViewById(R.id.co_britehealth_android_responseView);

        int screenWidth;

        if (android.os.Build.VERSION.SDK_INT < 10) {

            Display display = getActivity().getWindowManager().getDefaultDisplay();
            screenWidth = display.getWidth();

        } else {

            DisplayMetrics metrics = new DisplayMetrics();
            getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
            screenWidth = metrics.widthPixels;

        }

        createProgressTimer();
        mTranslateAnimationIntro = new TranslateAnimation(screenWidth, 0, 0, 0);
        mTranslateAnimationIntro.setDuration(200);
        mTranslateAnimationIntro.setAnimationListener(new Animation.AnimationListener() {

            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {

                startProgressTimer();

                stopTimer();

                mCountDownTimer = new CountDownTimer(5050, 1000) {

                    @Override
                    public void onTick(long millisUntilFinished) {

                        mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished) / 1000)));
                        currentTick = millisUntilFinished;

                    }

                    @Override
                    public void onFinish() {

                        currentTick = 5050;

                        stopProgressTimer();
                        ((TestManager) getTestManager()).setProcessingTime(mTimeBuffer);
                        resetProgressTimer();

                        ((TestManager) getTestManager()).setTrialFinishTime(System.currentTimeMillis());

                        ((TestManager) getTestManager()).timeout();

                        if (((TestManager) getTestManager()).getLocation() < TestManager.NUM_TRIALS) {
                            updateUI();
                        } else {
                            getTestManager().finishTest(System.currentTimeMillis());
                        }

                        resetProgressTimer();

                    }

                };

                ((TestManager) getTestManager()).setTrialStartTime(System.currentTimeMillis());
                mCountDownTimer.start();
                enableButtons();

            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }

        });

        mTranslateAnimationOutro = new TranslateAnimation(0, -screenWidth, 0, 0);
        mTranslateAnimationOutro.setDuration(200);
        mTranslateAnimationOutro.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

                stopProgressTimer();
                ((TestManager) getTestManager()).setProcessingTime(mTimeBuffer);
                resetProgressTimer();

                disableButtons();

            }

            @Override
            public void onAnimationEnd(Animation animation) {

                mWordTextView.setTextColor(
                        getResources().getColor(
                                ((TestManager) getTestManager()).getColorId()
                        )
                );

                mWordTextView.setText(
                        ((TestManager) getTestManager()).getWord()
                );

                mWordTextView.startAnimation(mTranslateAnimationIntro);

                mCounterTextView.setText(
                        String.format("%02d / 20", ((TestManager) getTestManager()).getLocation() + 1)
                );

            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });

        mCountDownTimer = new CountDownTimer(5050, 1000) {
            @Override
            public void onTick(long millisUntilFinished) {

                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished) / 1000)));
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {

                currentTick = 5050;

                ((TestManager) getTestManager()).setTrialFinishTime(System.currentTimeMillis());

                ((TestManager) getTestManager()).timeout();

                if (((TestManager) getTestManager()).getLocation() < TestManager.NUM_TRIALS) {
                    updateUI();
                } else {
                    getTestManager().finishTest(System.currentTimeMillis());
                }

            }
        };

        return rootView;

    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {

        super.onViewCreated(view, savedInstanceState);

        mWordTextView.setTextColor(
                getResources().getColor(
                        ((TestManager) getTestManager()).getColorId()
                )
        );

        mWordTextView.setText(
                ((TestManager) getTestManager()).getWord()
        );

        mWordTextView.startAnimation(mTranslateAnimationIntro);

        mCounterTextView.setText(
                String.format("%02d / 20", ((TestManager) getTestManager()).getLocation() + 1)
        );

        ((TestManager) getTestManager()).setTrialStartTime(System.currentTimeMillis());

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.STROOP_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.STROOP_NUM_QUITS_KEY, 0);
        setRestarts(numQuits);

    }

    /* TestCallbacks */

    @Override
    public void onCreateTest() {


        if (mRestarted) {

            setupTimer();
            updateUI();

        }

    }

    @Override
    public void onStartTest(long startTime) {

        startTimer();
        ((TestManager) getTestManager()).setTrialStartTime(startTime);

    }

    @Override
    public void onPauseTest(long pauseTime) {

        stopTimer();
        stopProgressTimer();

    }

    @Override
    public void onResumeTest(long resumeTime) {

        startProgressTimer();
        ((TestManager) getTestManager()).setTrialStartTime(resumeTime);

        mCountDownTimer = new CountDownTimer(currentTick + 50, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {

                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished) / 1000)));
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {

                currentTick = 5050;

                ((TestManager) getTestManager()).setTrialFinishTime(System.currentTimeMillis());

                ((TestManager) getTestManager()).timeout();

                if (((TestManager) getTestManager()).getLocation() < TestManager.NUM_TRIALS) {
                    updateUI();
                } else {
                    getTestManager().finishTest(System.currentTimeMillis());
                }

            }

        };

        mCountDownTimer.start();

    }

    @Override
    public void onFinishTest(long finishTime) {

        stopTimer();
        mPositiveButton.setEnabled(false);
        mNegativeButton.setEnabled(false);

    }

    @Override
    public void onRestartTest() {

        mRestarted = true;
        resetProgressTimer();

    }

    @Override
    public void onDisplayTestScores(BaseTestScores baseTestScores) {

        long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

        getActivity().getContentResolver().delete(
                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                DBContract.NextAssessmentTimesTable._ID + " = ?",
                new String[]{String.valueOf(TestModel.TYPE)}
        );

        ContentValues values = new ContentValues();
        values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
        values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, baseTestScores.getScore());
        values.put(
                DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                nextTime
        );

        getActivity()
                .getContentResolver()
                .insert(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        values
                );

        Introduction introduction = (Introduction) getAdapter().getFragmentList().get(0);
        introduction.showScore(baseTestScores.getScore());
        introduction.showNextAssessment(nextTime);

        getViewPager().setEnabled(true);

        getFragmentManager()
                .beginTransaction()
                .remove(this)
                .commit();

    }

    /* End of TestCallbacks */

    /* PauseScreenListener */

    @Override
    public void onResumeClick() {

        super.onResumeClick();
        getTestManager().resumeTest(System.currentTimeMillis());

    }

    @Override
    public void onTutorialClick() {

        super.onTutorialClick();

        getFragmentManager()
                .beginTransaction()
                .addToBackStack(null)
                .replace(R.id.co_britehealth_android_container_main, new Tutorial())
                .commit();

    }

    @Override
    public void onRestartClick() {

        super.onRestartClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.STROOP_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.STROOP_NUM_QUITS_KEY, 0);
        numQuits++;

        preferences.edit()
                .putInt(TestManager.STROOP_NUM_QUITS_KEY, numQuits)
                .apply();

    }

    @Override
    public void onQuitClick() {

        super.onQuitClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.STROOP_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.STROOP_NUM_QUITS_KEY, 0);

        if (numQuits >= 1) {

            long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

            Cursor cursor = getActivity()
                    .getContentResolver()
                    .query(
                            DBContract.NextAssessmentTimesTable.CONTENT_URI,
                            null,
                            DBContract.NextAssessmentTimesTable._ID + " = ?",
                            new String[]{String.valueOf(TestModel.TYPE)},
                            null
                    );

            int score = 0;

            if (cursor.moveToFirst()) {

                score = cursor.getInt(
                        cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
                );

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, score);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .update(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values,
                                DBContract.NextAssessmentTimesTable._ID + " = ?",
                                new String[]{String.valueOf(TestModel.TYPE)}
                        );

            } else {

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, -1);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .insert(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values
                        );

            }

            cursor.close();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(0);
            introduction.showScore(score);
            introduction.showNextAssessment(nextTime);

            getViewPager().setEnabled(true);

            preferences.edit()
                    .putInt(TestManager.STROOP_NUM_QUITS_KEY, 0)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

        } else {

            numQuits++;
            preferences.edit()
                    .putInt(TestManager.STROOP_NUM_QUITS_KEY, numQuits)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(0);
            introduction.enableButtons();

            ((BriteHealthAssessmentActivity) getActivity()).showIntroduction(0);

        }

    }

    /* End of PauseScreenListener */

    /* View.OnClickListener */

    @Override
    public void onClick(View v) {

        mCountDownTimer.cancel();
        mCountDownTimer = null;
        mCountDownTimer = new CountDownTimer(5050, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {

                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished) / 1000)));
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {

                currentTick = 5000;

                ((TestManager) getTestManager()).setTrialFinishTime(System.currentTimeMillis());

                ((TestManager) getTestManager()).timeout();

                if (((TestManager) getTestManager()).getLocation() < TestManager.NUM_TRIALS) {
                    updateUI();
                } else {
                    getTestManager().finishTest(System.currentTimeMillis());
                }

            }

        };

        ((TestManager) getTestManager()).setTrialFinishTime(System.currentTimeMillis());

        boolean userIsCorrect;
        if (v.getId() == R.id.co_britehealth_android_positive_button) {
            userIsCorrect = ((TestManager) getTestManager()).setUserAnswer(true);
        } else {
            userIsCorrect = ((TestManager) getTestManager()).setUserAnswer(false);
        }

        if (userIsCorrect) {
            mResponseView.setType(ResponseView.CORRECT);
        } else {
            mResponseView.setType(ResponseView.WRONG);
        }

        mResponseView.startAnimation(mAlphaAnimation);

        if (((TestManager) getTestManager()).getLocation() < TestManager.NUM_TRIALS) {
            updateUI();
        } else {
            getTestManager().finishTest(System.currentTimeMillis());
        }

    }

    /* End of View.OnClickListener */

    /* Toolbar.OnMenuItemClickListener */

    @Override
    public boolean onMenuItemClick(MenuItem item) {

        getTestManager().pauseTest(System.currentTimeMillis());
        showPauseScreen();

        return true;

    }

    /* End of Toolbar.OnMenuItemClickListener */

    /* TestView */

    private void updateUI() {
        mWordTextView.startAnimation(mTranslateAnimationOutro);
    }

    private void setupTimer() {

        mCountDownTimer = new CountDownTimer(5050, 1000) {
            @Override
            public void onTick(long millisUntilFinished) {

                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished) / 1000)));
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {

                currentTick = 5050;

                ((TestManager) getTestManager()).setTrialFinishTime(System.currentTimeMillis());

                ((TestManager) getTestManager()).timeout();

                if (((TestManager) getTestManager()).getLocation() < TestManager.NUM_TRIALS) {
                    updateUI();
                } else {
                    getTestManager().finishTest(System.currentTimeMillis());
                }

            }
        };

    }

    private void startTimer() {
        mCountDownTimer.start();
    }

    private void stopTimer() {

        if (mCountDownTimer != null) {

            mCountDownTimer.cancel();
            mCountDownTimer = null;

        }

    }

    private void disableButtons() {

        mPositiveButton.setEnabled(false);
        mNegativeButton.setEnabled(false);

    }

    private void enableButtons() {

        mPositiveButton.setEnabled(true);
        mNegativeButton.setEnabled(true);

    }

    /* End of TestView */

    private void createProgressTimer() {

        mHandler = new Handler();
        mRunnable = new Runnable() {

            @Override
            public void run() {

                mTimeInMilliseconds = SystemClock.uptimeMillis() - mStartTime;
                mHandler.postDelayed(this, 0);

            }

        };

    }

    private void startProgressTimer() {

        mStartTime = SystemClock.uptimeMillis();
        mHandler.postDelayed(mRunnable, 0);

    }

    private void stopProgressTimer() {

        mTimeBuffer += mTimeInMilliseconds;
        mHandler.removeCallbacks(mRunnable);

    }

    private void resetProgressTimer() {

        mStartTime = 0;
        mTimeInMilliseconds = 0;
        mTimeBuffer = 0;
        mHandler.removeCallbacks(mRunnable);
        mHandler = null;
        mRunnable = null;

        createProgressTimer();

    }

}
