package co.britehealth.android.assessment.stroop;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

import java.util.Date;


public class TestTrial implements Parcelable {

    private transient int mWordIndex;
    private transient int mColorIndex;

    @SerializedName("text")
    private String mWord;

    @SerializedName("color")
    private String mColor;

    @SerializedName("start")
    private Date mStartDate;

    @SerializedName("end")
    private Date mFinishDate;

    @SerializedName("processing_time")
    private long mProcessingTime;

    @SerializedName("is_correct")
    private boolean mCorrect;

    public TestTrial(int wordId, int colorIndex) {

        mWordIndex = wordId;
        mWord = TestManager.WORDS[wordId];
        mColorIndex = colorIndex;
        mColor = TestManager.WORDS[colorIndex];

    }

    public void setStartDate(Date startDate) {
        mStartDate = startDate;
    }

    public void setFinishDate(Date finishDate) {
        mFinishDate = finishDate;
    }

    public void setProcessingTime(long processingTime) {
        mProcessingTime = processingTime;
    }

    public void setCorrect(boolean correct) {
        mCorrect = correct;
    }

    public int getWordIndex() {
        return mWordIndex;
    }

    public int getColorIndex() {
        return mColorIndex;
    }

    public String getWord() {
        return mWord;
    }

    public String getColor() {
        return mColor;
    }

    public Date getStartDate() {
        return mStartDate;
    }

    public Date getFinishDate() {
        return mFinishDate;
    }

    public long getProcessingTime() {
        return mProcessingTime;
    }

    public boolean isCorrect() {
        return mCorrect;
    }

    /* Parcelable */

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeInt(mWordIndex);
        dest.writeInt(mColorIndex);
        dest.writeString(mWord);
        dest.writeString(mColor);
        dest.writeLong(mStartDate.getTime());
        dest.writeLong(mFinishDate.getTime());
        dest.writeLong(mProcessingTime);
        dest.writeByte((byte) (mCorrect ? 1 : 0));

    }

    public static final Creator<TestTrial> CREATOR = new Creator<TestTrial>() {

        @Override
        public TestTrial createFromParcel(Parcel source) {
            return new TestTrial(source);
        }

        @Override
        public TestTrial[] newArray(int size) {
            return new TestTrial[size];
        }

    };

    private TestTrial(Parcel parcel) {

        mWordIndex = parcel.readInt();
        mColorIndex = parcel.readInt();
        mWord = parcel.readString();
        mColor = parcel.readString();
        mStartDate = new Date(parcel.readLong());
        mFinishDate = new Date(parcel.readLong());
        mProcessingTime = parcel.readLong();
        mCorrect = parcel.readByte() != 0;

    }

    /* End of Parcelable */

}
