package co.britehealth.android.assessment.stroop;

import android.os.Parcel;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

import co.britehealth.android.assessment.framework.BaseTestModel;


public class TestModel extends BaseTestModel {

    public static final int TYPE = 1;

    @SerializedName("num_trials")
    private int mNumTrials;

    @SerializedName("num_correct")
    private int mNumCorrect;

    @SerializedName("num_wrong")
    private int mNumWrong;

    @SerializedName("trials")
    private List<TestTrial> mTestTrialList;

    public TestModel(int type) {

        super(type);

        mNumCorrect = 0;
        mNumWrong = 0;

    }

    public void setNumTrials(int numTrials) {
        mNumTrials = numTrials;
    }

    public void setNumCorrect(int numCorrect) {
        mNumCorrect = numCorrect;
    }

    public void setNumWrong(int numWrong) {
        mNumWrong = numWrong;
    }

    public void setTestDataList(List<TestTrial> testTrialList) {
        mTestTrialList = testTrialList;
    }

    public int getNumTrials() {
        return mNumTrials;
    }

    public int getNumCorrect() {
        return mNumCorrect;
    }

    public int getNumWrong() {
        return mNumWrong;
    }

    public List<TestTrial> getTestDataList() {
        return mTestTrialList;
    }

    /* Parcelable */

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeInt(getType());
        dest.writeInt(getUserId());
        dest.writeLong(getStartDate().getTime());
        dest.writeLong(getFinishDate().getTime());
        dest.writeDouble(getScore());
        dest.writeInt(mNumTrials);
        dest.writeInt(mNumCorrect);
        dest.writeInt(mNumWrong);
        dest.writeTypedList(mTestTrialList);

    }

    public static final Creator<TestModel> CREATOR = new Creator<TestModel>() {

        @Override
        public TestModel createFromParcel(Parcel source) {
            return new TestModel(source);
        }

        @Override
        public TestModel[] newArray(int size) {
            return new TestModel[size];
        }

    };

    protected TestModel(Parcel parcel) {

        super(parcel);
        mNumTrials = parcel.readInt();
        mNumCorrect = parcel.readInt();
        mNumWrong = parcel.readInt();
        mTestTrialList = new ArrayList<>();
        parcel.readTypedList(mTestTrialList, TestTrial.CREATOR);

    }

    /* End of Parcelable */

}
