package co.britehealth.android.assessment.shape.recall;

import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;

import co.britehealth.android.R;
import co.britehealth.android.assessment.common.BriteHealthShape;


public class TutorialTwo extends Fragment {

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_recall_tutorial_two, container, false);

        BriteHealthShape shape1 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_one);
        shape1.setProperties(
                BriteHealthShape.ShapeType.PARALLELOGRAM,
                BriteHealthShape.ShapeColor.GREEN,
                BriteHealthShape.ShapePattern.DOTTED
        );

        BriteHealthShape shape2 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_two);
        shape2.setProperties(
                BriteHealthShape.ShapeType.CIRCLE,
                BriteHealthShape.ShapeColor.BLUE,
                BriteHealthShape.ShapePattern.SOLID
        );

        BriteHealthShape shape3 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_three);
        shape3.setProperties(
                BriteHealthShape.ShapeType.PARALLELOGRAM,
                BriteHealthShape.ShapeColor.ORANGE,
                BriteHealthShape.ShapePattern.STRIPES
        );
        setAlpha(shape3, 0.2f);

        BriteHealthShape shape4 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_four);
        shape4.setProperties(
                BriteHealthShape.ShapeType.DIAMOND,
                BriteHealthShape.ShapeColor.RED,
                BriteHealthShape.ShapePattern.SOLID
        );

        BriteHealthShape shape5 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_five);
        shape5.setProperties(
                BriteHealthShape.ShapeType.DIAMOND,
                BriteHealthShape.ShapeColor.PURPLE,
                BriteHealthShape.ShapePattern.DOTTED
        );
        setAlpha(shape5, 0.2f);

        BriteHealthShape shape6 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_six);
        shape6.setProperties(
                BriteHealthShape.ShapeType.SQUARE,
                BriteHealthShape.ShapeColor.ORANGE,
                BriteHealthShape.ShapePattern.EMPTY
        );
        setAlpha(shape6, 0.2f);

        BriteHealthShape shape7 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_seven);
        shape7.setProperties(
                BriteHealthShape.ShapeType.SQUARE,
                BriteHealthShape.ShapeColor.GREEN,
                BriteHealthShape.ShapePattern.STRIPES
        );

        BriteHealthShape shape8 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_eight);
        shape8.setProperties(
                BriteHealthShape.ShapeType.S,
                BriteHealthShape.ShapeColor.BLUE,
                BriteHealthShape.ShapePattern.EMPTY
        );

        BriteHealthShape shape9 = (BriteHealthShape) rootView.findViewById(R.id.co_britehealth_android_shape_nine);
        shape9.setProperties(
                BriteHealthShape.ShapeType.S,
                BriteHealthShape.ShapeColor.RED,
                BriteHealthShape.ShapePattern.SOLID
        );
        setAlpha(shape9, 0.2f);

        return rootView;

    }

    private void setAlpha(View view, float alpha) {

        if (Build.VERSION.SDK_INT < 11) {

            final AlphaAnimation animation = new AlphaAnimation(alpha, alpha);
            animation.setDuration(1);
            animation.setFillAfter(true);
            view.startAnimation(animation);

        } else {
            view.setAlpha(alpha);
        }

    }

}
