package co.britehealth.android.assessment.shape.recall;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;
import java.util.Collections;

import co.britehealth.android.R;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.BriteHealthShape;
import co.britehealth.android.assessment.common.ResponseView;
import co.britehealth.android.assessment.common.SquareCardView;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.BaseTestView;
import co.britehealth.android.model.data.DBContract;


public class TestViewTwo extends BaseTestView
        implements
        View.OnClickListener,
        Toolbar.OnMenuItemClickListener {

    private static final String SCREEN_NAME = "Shape Recall: " + TestViewTwo.class.getSimpleName();
    private Tracker mTracker;

    private static final long NEXT_ASSESSMENT_DELAY = 2 * 7 * 24 * 60 * 60 * 1000;

    private TextView mTimerTextView;

    private long currentTick;
    private boolean mRestarted;
    private CountDownTimer mCountdownTimer;
    private Button mButton;

    private Toolbar mToolbar;
    private ArrayList<Double> mSelected;
    private ArrayList<ResponseView> mResponseViews;

    private int mCount;

    private Handler mHandler;
    private Runnable mRunnable;
    private long mStartTime;
    private long mTimeInMilliseconds;
    private long mTimeBuffer;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        BriteHealthAssessmentActivity activity = (BriteHealthAssessmentActivity) getActivity();
        mTracker = activity.getDefaultTracker();

        mRestarted = false;
        mSelected = new ArrayList<>();

        setTestManager(
                new TestManager(getActivity(), this)
        );

        getTestManager()
                .setTestModel(
                        (TestModel) getArguments().getParcelable(TestManager.EXTRA_TEST_MODEL)
                );

        ArrayList<ShapeRecallHelper> helpers = getArguments().getParcelableArrayList(TestManager.EXTRA_HELPER_LIST);
        ((TestManager) getTestManager()).setHelperList(helpers);

        createProgressTimer();

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_shape_recall_two, container, false);

        mToolbar = (Toolbar) rootView.findViewById(R.id.co_britehealth_android_toolbar);
        mToolbar.inflateMenu(R.menu.co_britehealth_android_test);
        mToolbar.setOnMenuItemClickListener(this);

        mTimerTextView = (TextView) mToolbar.findViewById(R.id.co_britehealth_android_timer_textView);
        mCountdownTimer = new CountDownTimer(60000, 1000) {

            long minutes;
            long seconds;

            @Override
            public void onTick(long millisUntilFinished) {

                minutes = ((millisUntilFinished + 200) / 1000) / 60;
                seconds = ((millisUntilFinished + 200) / 1000) % 60;

                mTimerTextView.setText(
                        String.format("%02d:%02d", minutes, seconds)
                );
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {
                getTestManager().finishTest(System.currentTimeMillis());
            }

        };

        ArrayList<SquareCardView> squareCardViews = new ArrayList<>();
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_1));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_2));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_3));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_4));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_5));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_6));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_7));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_8));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_9));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_10));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_11));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_12));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_13));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_14));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_15));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_16));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_17));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_18));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_19));
        squareCardViews.add((SquareCardView) rootView.findViewById(R.id.co_britehealth_android_card_20));

        Collections.shuffle(squareCardViews);

        ArrayList<BriteHealthShape> briteHealthShapes = new ArrayList<>();
        for (int i = 0; i < squareCardViews.size(); i++) {
            briteHealthShapes.add((BriteHealthShape) squareCardViews.get(i).getChildAt(0));
        }

        mResponseViews = new ArrayList<>();
        for (int i = 0; i < squareCardViews.size(); i++) {
            mResponseViews.add((ResponseView) squareCardViews.get(i).getChildAt(1));
        }

        for (int i = 0; i < 12; i++) {

            briteHealthShapes.get(i)
                    .setProperties(
                            ((TestManager) getTestManager()).getShapeHelper(i).getType(),
                            ((TestManager) getTestManager()).getShapeHelper(i).getColor(),
                            ((TestManager) getTestManager()).getShapeHelper(i).getPattern()
                    );

            briteHealthShapes.get(i).setOnClickListener(this);
            briteHealthShapes.get(i).setTag((double) (i + 5000));

            mResponseViews.get(i).setType(ResponseView.CORRECT);

        }

        for (int i = 12; i < 20; i++) {

            briteHealthShapes.get(i)
                    .setProperties(
                            ((TestManager) getTestManager()).getShapeHelper(i).getType(),
                            ((TestManager) getTestManager()).getShapeHelper(i).getColor(),
                            ((TestManager) getTestManager()).getShapeHelper(i).getPattern()
                    );

            briteHealthShapes.get(i).setOnClickListener(this);
            briteHealthShapes.get(i).setTag((double) (i + 5000));

            mResponseViews.get(i).setType(ResponseView.WRONG);

        }

        mButton = (Button) rootView.findViewById(R.id.co_britehealth_android_done);
        mButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getTestManager().finishTest(System.currentTimeMillis());
            }
        });

        return rootView;

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.SHAPE_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.SHAPE_NUM_QUITS_KEY, 0);
        setRestarts(numQuits);

    }

    /* TestCallbacks */

    @Override
    public void onCreateTest() {

    }

    @Override
    public void onStartTest(long startTime) {

        if (mCountdownTimer != null) {
            mCountdownTimer.start();
        }

        if (!mRestarted) {
            ((TestManager) getTestManager()).setStartRecallState(startTime);
        }

        startProgressTimer();

    }

    @Override
    public void onPauseTest(long pauseTime) {

        stopProgressTimer();

        mCountdownTimer.cancel();
        mCountdownTimer = null;

    }

    @Override
    public void onResumeTest(long resumeTime) {

        startProgressTimer();

        mCountdownTimer = new CountDownTimer(currentTick, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {

                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {
                getTestManager().finishTest(System.currentTimeMillis());
            }

        };

        mCountdownTimer.start();

    }

    @Override
    public void onFinishTest(long finishTime) {

        stopProgressTimer();
        ((TestManager) getTestManager()).setInitialProcessingTime(getArguments().getLong(TestManager.EXTRA_INITIAL_TIME));
        ((TestManager) getTestManager()).setRecallProcessingTime(mTimeBuffer);

        mCountdownTimer.cancel();
        ((TestManager) getTestManager()).setStartTime();
        ((TestManager) getTestManager()).setEndRecallState(finishTime);
        ((TestManager) getTestManager()).computeNumberOfCorrects(mSelected);

        mButton.setEnabled(false);
        mToolbar.getMenu().clear();

    }

    @Override
    public void onRestartTest() {

        mRestarted = true;

        resetProgressTimer();

        getFragmentManager()
                .beginTransaction()
                .replace(R.id.co_britehealth_android_container_main, new TestViewOne())
                .commit();

    }

    @Override
    public void onDisplayTestScores(BaseTestScores baseTestScores) {

        long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

        getActivity().getContentResolver().delete(
                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                DBContract.NextAssessmentTimesTable._ID + " = ?",
                new String[]{String.valueOf(TestModel.TYPE)}
        );

        ContentValues values = new ContentValues();
        values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
        values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, baseTestScores.getScore());
        values.put(
                DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                nextTime
        );

        getActivity()
                .getContentResolver()
                .insert(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        values
                );

        Introduction introduction = (Introduction) getAdapter().getFragmentList().get(2);
        introduction.showScore(baseTestScores.getScore());
        introduction.showNextAssessment(nextTime);

        for (int i = 0; i < mSelected.size(); i++) {
            mResponseViews.get((int) (mSelected.get(i) - 5000)).setVisibility(View.VISIBLE);
        }

        mCountdownTimer = null;
        mCountdownTimer = new CountDownTimer(5000, 1000) {
            @Override
            public void onTick(long millisUntilFinished) {

            }

            @Override
            public void onFinish() {

                getViewPager().setEnabled(true);

                getFragmentManager()
                        .beginTransaction()
                        .remove(TestViewTwo.this)
                        .commit();

            }
        };

        mCountdownTimer.start();

    }

    /* End of TestCallbacks */

    /* View.OnClickListener */

    @Override
    public void onClick(View v) {

        BriteHealthShape shape = (BriteHealthShape) v;

        double tag = (double) shape.getTag();

        if (!shape.isChecked()) {

            if (mCount < 12) {

                mCount++;
                setAlpha(v, 0.2f);
                mSelected.add(tag);
                shape.setChecked(true);

            } else {

                Toast.makeText(getActivity(), "You cannot select more than 12 shapes.", Toast.LENGTH_SHORT).show();

            }

        } else {

            mCount--;
            setAlpha(v, 1f);
            mSelected.remove(tag);
            shape.setChecked(false);

        }

    }

    /* End of View.OnClickListener */

    /* PauseScreenListener */

    @Override
    public void onResumeClick() {

        super.onResumeClick();
        getTestManager().resumeTest(System.currentTimeMillis());

    }

    @Override
    public void onTutorialClick() {

        super.onTutorialClick();

        getFragmentManager()
                .beginTransaction()
                .addToBackStack(null)
                .replace(R.id.co_britehealth_android_container_main, new Tutorial())
                .commit();

    }

    @Override
    public void onRestartClick() {

        super.onRestartClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.SHAPE_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.SHAPE_NUM_QUITS_KEY, 0);
        numQuits++;

        preferences.edit()
                .putInt(TestManager.SHAPE_NUM_QUITS_KEY, numQuits)
                .apply();

    }

    @Override
    public void onQuitClick() {

        super.onQuitClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.SHAPE_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.SHAPE_NUM_QUITS_KEY, 0);

        if (numQuits >= 1) {

            long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

            Cursor cursor = getActivity()
                    .getContentResolver()
                    .query(
                            DBContract.NextAssessmentTimesTable.CONTENT_URI,
                            null,
                            DBContract.NextAssessmentTimesTable._ID + " = ?",
                            new String[]{String.valueOf(TestModel.TYPE)},
                            null
                    );

            int score = 0;

            if (cursor.moveToFirst()) {

                score = cursor.getInt(
                        cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
                );

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, score);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .update(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values,
                                DBContract.NextAssessmentTimesTable._ID + " = ?",
                                new String[]{String.valueOf(TestModel.TYPE)}
                        );

            } else {

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, -1);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .insert(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values
                        );

            }

            cursor.close();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(2);
            introduction.showScore(score);
            introduction.showNextAssessment(nextTime);

            getViewPager().setEnabled(true);

            preferences.edit()
                    .putInt(TestManager.SHAPE_NUM_QUITS_KEY, 0)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

        } else {

            numQuits++;
            preferences.edit()
                    .putInt(TestManager.SHAPE_NUM_QUITS_KEY, numQuits)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(2);
            introduction.enableButtons();

            ((BriteHealthAssessmentActivity) getActivity()).showIntroduction(2);

        }

    }

    /* End of PauseScreenListener */

    /* Toolbar.OnMenuItemClickListener */

    @Override
    public boolean onMenuItemClick(MenuItem item) {

        getTestManager().pauseTest(System.currentTimeMillis());
        showPauseScreen();

        return true;

    }

    /* End of Toolbar.OnMenuItemClickListener */

    private void setAlpha(View view, float alpha) {

        if (Build.VERSION.SDK_INT < 11) {

            final AlphaAnimation animation = new AlphaAnimation(alpha, alpha);
            animation.setDuration(1);
            animation.setFillAfter(true);
            view.startAnimation(animation);

        } else {
            view.setAlpha(alpha);
        }

    }

    private void createProgressTimer() {

        mHandler = new Handler();
        mRunnable = new Runnable() {

            @Override
            public void run() {

                mTimeInMilliseconds = SystemClock.uptimeMillis() - mStartTime;
                long updatedTime = mTimeBuffer + mTimeInMilliseconds;

                int seconds = (int) (updatedTime / 1000);
                int minutes = seconds / 60;
                seconds = seconds % 60;
                int milliseconds = (int) (updatedTime % 1000);

                mHandler.postDelayed(this, 0);

            }

        };

    }

    private void startProgressTimer() {

        mStartTime = SystemClock.uptimeMillis();
        mHandler.postDelayed(mRunnable, 0);

    }

    private void stopProgressTimer() {

        mTimeBuffer += mTimeInMilliseconds;
        mHandler.removeCallbacks(mRunnable);

    }

    private void resetProgressTimer() {

        mStartTime = 0;
        mTimeInMilliseconds = 0;
        mTimeBuffer = 0;
        mHandler.removeCallbacks(mRunnable);
        mHandler = null;
        mRunnable = null;

        createProgressTimer();

    }


}
