package co.britehealth.android.assessment.shape.recall;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;

import co.britehealth.android.R;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.BriteHealthShape;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.BaseTestView;
import co.britehealth.android.model.data.DBContract;


public class TestViewOne extends BaseTestView implements Toolbar.OnMenuItemClickListener {

    private static final String SCREEN_NAME = "Shape Recall: " + TestViewOne.class.getSimpleName();
    private Tracker mTracker;

    private static final long NEXT_ASSESSMENT_DELAY = 2 * 7 * 24 * 60 * 60 * 1000;

    private Toolbar mToolbar;
    private TextView mTimerTextView;

    private long currentTick;
    private boolean mRestarted;
    private CountDownTimer mCountdownTimer;

    private Handler mHandler;
    private Runnable mRunnable;
    private long mStartTime;
    private long mTimeInMilliseconds;
    private long mTimeBuffer;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        BriteHealthAssessmentActivity activity = (BriteHealthAssessmentActivity) getActivity();
        mTracker = activity.getDefaultTracker();

        mRestarted = false;

        setTestManager(
                new TestManager(getActivity(), this)
        );
        getTestManager().createTest();

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_shape_recall_one, container, false);

        mToolbar = (Toolbar) rootView.findViewById(R.id.co_britehealth_android_toolbar);
        mToolbar.inflateMenu(R.menu.co_britehealth_android_test);
        mToolbar.setOnMenuItemClickListener(this);

        mTimerTextView = (TextView) mToolbar.findViewById(R.id.co_britehealth_android_timer_textView);
        mCountdownTimer = new CountDownTimer(30000, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {

                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {
                startShapeRecall();
            }

        };

        setupShapes(rootView);

        Button button = (Button) rootView.findViewById(R.id.co_britehealth_android_next);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startShapeRecall();
            }
        });

        return rootView;

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.SHAPE_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.SHAPE_NUM_QUITS_KEY, 0);
        setRestarts(numQuits);

    }

    /* TestCallbacks */

    @Override
    public void onCreateTest() {

        if (mRestarted) {
            setupShapes(getView());
        }

        createProgressTimer();

    }

    @Override
    public void onStartTest(long startTime) {

        ((TestManager) getTestManager()).setStartInitialState(startTime);
        mCountdownTimer.start();

        startProgressTimer();

    }

    @Override
    public void onPauseTest(long pauseTime) {

        stopProgressTimer();

        mCountdownTimer.cancel();
        mCountdownTimer = null;

    }

    @Override
    public void onResumeTest(long resumeTime) {

        startProgressTimer();

        mCountdownTimer = new CountDownTimer(currentTick, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {

                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {
                startShapeRecall();
            }

        };

        mCountdownTimer.start();

    }

    @Override
    public void onFinishTest(long finishTime) {

        stopProgressTimer();

    }

    @Override
    public void onRestartTest() {

        mRestarted = true;

        resetProgressTimer();

        mCountdownTimer = new CountDownTimer(30000, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {

                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;

            }

            @Override
            public void onFinish() {
                startShapeRecall();
            }

        };

    }

    @Override
    public void onDisplayTestScores(BaseTestScores baseTestScores) {

    }

    /* End of TestCallbacks */

    /* PauseScreenListener */

    @Override
    public void onResumeClick() {

        super.onResumeClick();
        getTestManager().resumeTest(System.currentTimeMillis());

    }

    @Override
    public void onTutorialClick() {

        super.onTutorialClick();

        getFragmentManager()
                .beginTransaction()
                .addToBackStack(null)
                .replace(R.id.co_britehealth_android_container_main, new Tutorial())
                .commit();

    }

    @Override
    public void onRestartClick() {

        super.onRestartClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.SHAPE_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.SHAPE_NUM_QUITS_KEY, 0);
        numQuits++;

        preferences.edit()
                .putInt(TestManager.SHAPE_NUM_QUITS_KEY, numQuits)
                .apply();

    }

    @Override
    public void onQuitClick() {

        super.onQuitClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.SHAPE_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.SHAPE_NUM_QUITS_KEY, 0);

        if (numQuits >= 1) {

            long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

            Cursor cursor = getActivity()
                    .getContentResolver()
                    .query(
                            DBContract.NextAssessmentTimesTable.CONTENT_URI,
                            null,
                            DBContract.NextAssessmentTimesTable._ID + " = ?",
                            new String[]{String.valueOf(TestModel.TYPE)},
                            null
                    );

            int score = 0;

            if (cursor.moveToFirst()) {

                score = cursor.getInt(
                        cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
                );

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, score);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .update(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values,
                                DBContract.NextAssessmentTimesTable._ID + " = ?",
                                new String[]{String.valueOf(TestModel.TYPE)}
                        );

            } else {

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, -1);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .insert(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values
                        );

            }

            cursor.close();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(2);
            introduction.showScore(score);
            introduction.showNextAssessment(nextTime);

            getViewPager().setEnabled(true);

            preferences.edit()
                    .putInt(TestManager.SHAPE_NUM_QUITS_KEY, 0)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

        } else {

            numQuits++;
            preferences.edit()
                    .putInt(TestManager.SHAPE_NUM_QUITS_KEY, numQuits)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(2);
            introduction.enableButtons();

            ((BriteHealthAssessmentActivity) getActivity()).showIntroduction(2);

        }

    }

    /* End of PauseScreenListener */

    /* Toolbar.OnMenuItemClickListener */

    @Override
    public boolean onMenuItemClick(MenuItem item) {

        getTestManager().pauseTest(System.currentTimeMillis());
        showPauseScreen();

        return true;

    }

    /* End of Toolbar.OnMenuItemClickListener */

    /* TestViewOne */

    private void setupShapes(View rootView) {

        ArrayList<BriteHealthShape> briteHealthShapes = new ArrayList<>();
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_1));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_2));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_3));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_4));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_5));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_6));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_7));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_8));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_9));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_10));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_11));
        briteHealthShapes.add((BriteHealthShape) rootView.findViewById(R.id.brite_health_shape_12));

        for (int i = 0; i < 12; i++) {

            briteHealthShapes
                    .get(i)
                    .setProperties(
                            ((TestManager) getTestManager()).getShapeHelper(i).getType(),
                            ((TestManager) getTestManager()).getShapeHelper(i).getColor(),
                            ((TestManager) getTestManager()).getShapeHelper(i).getPattern()
                    );

        }

    }

    private void startShapeRecall() {

        stopProgressTimer();

        ((TestManager) getTestManager()).setEndInitialState(System.currentTimeMillis());

        Bundle bundle = new Bundle();
        bundle.putParcelable(TestManager.EXTRA_TEST_MODEL, ((TestManager) getTestManager()).getTestModel());
        bundle.putParcelableArrayList(TestManager.EXTRA_HELPER_LIST, ((TestManager) getTestManager()).getHelperList());
        bundle.putLong(TestManager.EXTRA_INITIAL_TIME, mTimeBuffer);

        TestViewTwo testViewTwo = new TestViewTwo();
        testViewTwo.setArguments(bundle);

        getFragmentManager()
                .beginTransaction()
                .replace(R.id.co_britehealth_android_container_main, testViewTwo)
                .commit();

    }

    /* End of TestViewOne */

    private void createProgressTimer() {

        mHandler = new Handler();
        mRunnable = new Runnable() {

            @Override
            public void run() {

                mTimeInMilliseconds = SystemClock.uptimeMillis() - mStartTime;
                long updatedTime = mTimeBuffer + mTimeInMilliseconds;

                int seconds = (int) (updatedTime / 1000);
                int minutes = seconds / 60;
                seconds = seconds % 60;
                int milliseconds = (int) (updatedTime % 1000);

                mHandler.postDelayed(this, 0);

            }

        };

    }

    private void startProgressTimer() {

        mStartTime = SystemClock.uptimeMillis();
        mHandler.postDelayed(mRunnable, 0);

    }

    private void stopProgressTimer() {

        mTimeBuffer += mTimeInMilliseconds;
        mHandler.removeCallbacks(mRunnable);

    }

    private void resetProgressTimer() {

        mStartTime = 0;
        mTimeInMilliseconds = 0;
        mTimeBuffer = 0;
        mHandler.removeCallbacks(mRunnable);
        mHandler = null;
        mRunnable = null;

    }


}
