package co.britehealth.android.assessment.shape.recall;

import android.os.Parcel;

import com.google.gson.annotations.SerializedName;

import java.util.Date;

import co.britehealth.android.assessment.framework.BaseTestModel;


public class TestModel extends BaseTestModel {

    public static final int TYPE = 3;

    @SerializedName("start_initial_state")
    private Date mStartInitialState;

    @SerializedName("end_initial_state")
    private Date mEndInitialState;

    @SerializedName("start_recall_state")
    private Date mStartRecallState;

    @SerializedName("end_recall_state")
    private Date mEndRecallState;

    @SerializedName("initial_processing_time")
    private long initialProcessingTime;

    @SerializedName("recall_processing_time")
    private long recallProcessingTime;

    @SerializedName("num_correct")
    private int mNumCorrect;

    public TestModel(int type) {

        super(type);
        mNumCorrect = 0;

    }

    public void setStartInitialState(Date startInitialState) {
        mStartInitialState = startInitialState;
    }

    public void setEndInitialState(Date endInitialState) {
        mEndInitialState = endInitialState;
    }

    public void setStartRecallState(Date startRecallState) {
        mStartRecallState = startRecallState;
    }

    public void setEndRecallState(Date endRecallState) {
        mEndRecallState = endRecallState;
    }

    public void setNumCorrect(int numCorrect) {
        mNumCorrect = numCorrect;
    }

    public void setInitialProcessingTime(long initialProcessingTime) {
        this.initialProcessingTime = initialProcessingTime;
    }

    public void setRecallProcessingTime(long recallProcessingTime) {
        this.recallProcessingTime = recallProcessingTime;
    }

    public Date getStartInitialState() {
        return mStartInitialState;
    }

    public Date getEndInitialState() {
        return mEndInitialState;
    }

    public Date getStartRecallState() {
        return mStartRecallState;
    }

    public Date getEndRecallState() {
        return mEndRecallState;
    }

    public long getRecallProcessingTime() {
        return recallProcessingTime;
    }

    public long getInitialProcessingTime() {
        return initialProcessingTime;
    }

    public int getNumCorrect() {
        return mNumCorrect;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeInt(getType());
        dest.writeInt(getUserId());
        dest.writeLong(getStartDate().getTime());
        if (getFinishDate() != null) {
            dest.writeLong(getFinishDate().getTime());
        }
        dest.writeDouble(getScore());
        dest.writeLong(mStartInitialState.getTime());
        dest.writeLong(mEndInitialState.getTime());
        dest.writeLong(mStartRecallState.getTime());
        if (mEndRecallState != null) {
            dest.writeLong(mEndRecallState.getTime());
        }
        dest.writeLong(initialProcessingTime);
        dest.writeLong(recallProcessingTime);
        dest.writeInt(mNumCorrect);

    }

    public static final Creator<TestModel> CREATOR = new Creator<TestModel>() {

        @Override
        public TestModel createFromParcel(Parcel source) {
            return new TestModel(source);
        }

        @Override
        public TestModel[] newArray(int size) {
            return new TestModel[size];
        }

    };

    protected TestModel(Parcel parcel) {

        super(parcel);
        mStartInitialState = new Date(parcel.readLong());
        mEndInitialState = new Date(parcel.readLong());
        mStartRecallState = new Date(parcel.readLong());
        mEndRecallState = new Date(parcel.readLong());
        initialProcessingTime = parcel.readLong();
        recallProcessingTime = parcel.readLong();
        mNumCorrect = parcel.readInt();

    }

}
