package co.britehealth.android.assessment.shape.recall;

import android.content.Context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

import co.britehealth.android.BriteHealthException;
import co.britehealth.android.assessment.common.BriteHealthShape.ShapeColor;
import co.britehealth.android.assessment.common.BriteHealthShape.ShapePattern;
import co.britehealth.android.assessment.common.BriteHealthShape.ShapeType;
import co.britehealth.android.assessment.framework.BaseTestManager;
import co.britehealth.android.assessment.framework.BaseTestModel;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.TestCallbacks;
import co.britehealth.android.util.DatabaseUtils;


public class TestManager extends BaseTestManager {

    public static final int RECALL_LIST_SIZE = 20;

    public static final String SHAPE_NUM_QUITS = "co_britehealth_android_shape_num_quits";
    public static final String SHAPE_NUM_QUITS_KEY = "co_britehealth_android_shape_num_quits_key";

    public static final String EXTRA_HELPER_LIST = "extra_helper_list";
    public static final String EXTRA_TEST_MODEL = "extra_test_model";
    public static final String EXTRA_INITIAL_TIME = "extra_initial_time";

    private ArrayList<ShapeRecallHelper> mHelperList;
    private int mNumWrongs;

    protected TestManager(Context context, TestCallbacks testCallbacks) {
        super(context, testCallbacks);
    }

    @Override
    public TestModel getTestModel() {
        return (TestModel) super.getTestModel();
    }

    @Override
    public void setTestModel(BaseTestModel testModel) {
        super.setTestModel(testModel);
    }

    public ArrayList<ShapeRecallHelper> getHelperList() {
        return mHelperList;
    }

    public void setHelperList(ArrayList<ShapeRecallHelper> helperList) {
        mHelperList = helperList;
    }

    public ShapeRecallHelper getShapeHelper(int location) {
        return mHelperList.get(location);
    }

    public void setStartInitialState(long time) {
        getTestModel().setStartInitialState(new Date(time));
    }

    public void setEndInitialState(long time) {
        getTestModel().setEndInitialState(new Date(time));
    }

    public void setStartRecallState(long time) {
        getTestModel().setStartRecallState(new Date(time));
    }

    public void setStartTime() {
        getTestModel().setStartDate(getTestModel().getStartInitialState());
    }

    public void setEndRecallState(long time) {
        getTestModel().setEndRecallState(new Date(time));
    }

    public void setInitialProcessingTime(long initialProcessingTime) {
        getTestModel().setInitialProcessingTime(initialProcessingTime);
    }

    public void setRecallProcessingTime(long recallProcessingTime) {
        getTestModel().setRecallProcessingTime(recallProcessingTime);
    }

    public void computeNumberOfCorrects(ArrayList<Double> selectedList) {

        int count = 0;
        mNumWrongs = 0;

        for (double i : selectedList) {

            if ((i - 5000) < 12) {
                count++;
            } else {
                mNumWrongs++;
            }

        }

        getTestModel().setNumCorrect(count);

    }

    @Override
    public void createTest() {

        TestModel testModel = new TestModel(TestModel.TYPE);

        int userId = DatabaseUtils.getCurrentUserId(getContext());
        if (userId != -1) {
            testModel.setUserId(userId);
        } else {

            throw new BriteHealthException(
                    "You need to register the current user with Brite Health before creating a test."
            );

        }

        setTestModel(testModel);

        ArrayList<ShapeRecallHelper> list = new ArrayList<>();

        for (ShapeType type : ShapeType.values()) {

            for (ShapeColor color : ShapeColor.values()) {

                for (ShapePattern pattern : ShapePattern.values()) {

                    list.add(
                            new ShapeRecallHelper(
                                    type,
                                    color,
                                    pattern
                            )
                    );

                }

            }

        }

        Collections.shuffle(list);

        mHelperList = new ArrayList<>();
        for (int i = 0; i < RECALL_LIST_SIZE; i++) {
            mHelperList.add(list.get(i));
        }

        super.createTest();

    }

    @Override
    public BaseTestScores computeBasicTestScores() {

        int score = (getTestModel().getNumCorrect() - (mNumWrongs / 3)) * (100 / 12);

        if (score > 100) {
            score = 100;
        } else if (score < 0) {
            score = 0;
        }

        TestScores testScores = new TestScores();
        testScores.setScore(score);
        return testScores;

    }

}
