package co.britehealth.android.assessment.shape.recall;

import android.os.Parcel;
import android.os.Parcelable;

import co.britehealth.android.assessment.common.BriteHealthShape.ShapeColor;
import co.britehealth.android.assessment.common.BriteHealthShape.ShapePattern;
import co.britehealth.android.assessment.common.BriteHealthShape.ShapeType;


public class ShapeRecallHelper implements Parcelable {

    private ShapeType mType;
    private ShapeColor mColor;
    private ShapePattern mPattern;

    public ShapeRecallHelper(ShapeType type, ShapeColor color, ShapePattern pattern) {

        mType = type;
        mColor = color;
        mPattern = pattern;

    }

    public ShapeType getType() {
        return mType;
    }

    public ShapeColor getColor() {
        return mColor;
    }

    public ShapePattern getPattern() {
        return mPattern;
    }

    /* Parcelable */

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeSerializable(mType);
        dest.writeSerializable(mColor);
        dest.writeSerializable(mPattern);

    }

    public static final Creator<ShapeRecallHelper> CREATOR = new Creator<ShapeRecallHelper>() {

        @Override
        public ShapeRecallHelper createFromParcel(Parcel source) {
            return new ShapeRecallHelper(source);
        }

        @Override
        public ShapeRecallHelper[] newArray(int size) {
            return new ShapeRecallHelper[size];
        }

    };

    private ShapeRecallHelper(Parcel parcel) {

        mType = (ShapeType) parcel.readSerializable();
        mColor = (ShapeColor) parcel.readSerializable();
        mPattern = (ShapePattern) parcel.readSerializable();

    }

    /* End of Parcelable */

}
