package co.britehealth.android.assessment.shape.recall;

import android.database.Cursor;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.Date;

import co.britehealth.android.R;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.BulletProgressBar;
import co.britehealth.android.assessment.common.ScoreProgressBar;
import co.britehealth.android.model.data.DBContract;


public class Introduction extends Fragment implements Toolbar.OnMenuItemClickListener {

    private static final String SCREEN_NAME = "Shape Recall: " + Introduction.class.getSimpleName();
    private Tracker mTracker;

    private int mLastScore;
    private long mNextAssessmentTime;

    private Button mStartTutorialButton;
    private Button mStartTestButton;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        BriteHealthAssessmentActivity activity = (BriteHealthAssessmentActivity) getActivity();
        mTracker = activity.getDefaultTracker();

        Cursor cursor = getActivity()
                .getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{String.valueOf(TestModel.TYPE)},
                        null
                );

        if (cursor.moveToFirst()) {

            mLastScore = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );
            mNextAssessmentTime = cursor.getLong(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME)
            );

        } else {

            mLastScore = -1;
            mNextAssessmentTime = 0;

        }

        cursor.close();

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_introduction, container, false);

        Toolbar toolbar = (Toolbar) rootView.findViewById(R.id.co_britehealth_android_toolbar);
        toolbar.inflateMenu(R.menu.co_britehealth_android_exit);
        toolbar.setOnMenuItemClickListener(this);

        BulletProgressBar bulletProgressBar = (BulletProgressBar) toolbar.findViewById(R.id.bullet_progress_bar);
        bulletProgressBar.setProgress(3);

        TextView nameTextView = (TextView) rootView.findViewById(R.id.co_britehealth_android_test_name);
        TextView functionTextView = (TextView) rootView.findViewById(R.id.co_britehealth_android_test_function);
        ImageView imageView = (ImageView) rootView.findViewById(R.id.co_britehealth_android_test_image);
        TextView descriptionTextView = (TextView) rootView.findViewById(R.id.co_britehealth_android_test_description);

        nameTextView.setText(getString(R.string.co_britehealth_android_introduction_name_shape_recall));
        functionTextView.setText(getString(R.string.co_britehealth_android_introduction_function_shape_recall));
        imageView.setImageResource(R.drawable.shape_recall_brain);
        descriptionTextView.setText(getString(R.string.co_britehealth_android_introduction_description_shape_recall));

        LinearLayout fastLinearLayout =
                (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_go_fast_layout);
        fastLinearLayout.setVisibility(View.GONE);

        if (mLastScore > -1) {
            showScore(mLastScore, rootView);
        }

        if (System.currentTimeMillis() > mNextAssessmentTime) {
            showButtons(rootView);
        } else {
            showNextAssessment(rootView);
        }

        return rootView;

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

    }

    /* Toolbar.OnMenuItemClickListener */

    @Override
    public boolean onMenuItemClick(MenuItem item) {

        getActivity().finish();
        return true;

    }

    /* End of Toolbar.OnMenuItemClickListener */

    /* Introduction */

    public void showScore(int score) {

        if (getView() != null) {

            CardView scoreLayout = (CardView) getView().findViewById(R.id.co_britehealth_android_score_layout);
            scoreLayout.setVisibility(View.VISIBLE);

            TextView scoreTextView = (TextView) scoreLayout.findViewById(R.id.co_britehealth_android_score_textView);
            scoreTextView.setText(String.valueOf(score));

            ScoreProgressBar scoreProgressBar =
                    (ScoreProgressBar) scoreLayout.findViewById(R.id.co_britehealth_android_score_progressBar);

            scoreProgressBar.setScore(score);

        }

    }

    public void showScore(int score, View rootView) {

        CardView scoreLayout = (CardView) rootView.findViewById(R.id.co_britehealth_android_score_layout);
        scoreLayout.setVisibility(View.VISIBLE);

        TextView scoreTextView = (TextView) scoreLayout.findViewById(R.id.co_britehealth_android_score_textView);
        scoreTextView.setText(String.valueOf(score));

        ScoreProgressBar scoreProgressBar =
                (ScoreProgressBar) scoreLayout.findViewById(R.id.co_britehealth_android_score_progressBar);

        scoreProgressBar.setScore(score);

    }

    public void showNextAssessment(long nextTime) {

        if (getView() != null) {

            LinearLayout buttonsLayout = (LinearLayout) getView().findViewById(R.id.co_britehealth_android_buttons_layout);
            buttonsLayout.setVisibility(View.GONE);

            LinearLayout assessmentLayout = (LinearLayout) getView().findViewById(R.id.co_britehealth_android_next_assessment);
            assessmentLayout.setVisibility(View.VISIBLE);

            TextView nextTextView =
                    (TextView) assessmentLayout.findViewById(R.id.co_britehealth_android_next_assessment_date_textView);

            nextTextView.setText(new Date(nextTime).toString());

        }

    }

    public void showNextAssessment(View rootView) {

        LinearLayout buttonsLayout = (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_buttons_layout);
        buttonsLayout.setVisibility(View.GONE);

        LinearLayout assessmentLayout = (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_next_assessment);
        assessmentLayout.setVisibility(View.VISIBLE);

        TextView nextTextView =
                (TextView) assessmentLayout.findViewById(R.id.co_britehealth_android_next_assessment_date_textView);

        nextTextView.setText(new Date(mNextAssessmentTime).toString());

    }

    public void showButtons(View rootView) {

        LinearLayout buttonsLayout = (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_buttons_layout);
        buttonsLayout.setVisibility(View.VISIBLE);

        mStartTutorialButton = (Button) rootView.findViewById(R.id.co_britehealth_android_start_tutorial);
        mStartTutorialButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                getFragmentManager()
                        .beginTransaction()
                        .addToBackStack(null)
                        .replace(R.id.co_britehealth_android_container_main, new Tutorial())
                        .commit();

            }
        });

        mStartTestButton = (Button) rootView.findViewById(R.id.co_britehealth_android_start_test);
        mStartTestButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                getFragmentManager()
                        .beginTransaction()
                        .replace(R.id.co_britehealth_android_container_main, new TestViewOne())
                        .commit();

                disableButtons();

            }
        });

    }

    public void disableButtons() {

        if (mStartTutorialButton != null && mStartTestButton != null) {

            mStartTutorialButton.setEnabled(false);
            mStartTestButton.setEnabled(false);

        }

    }

    public void enableButtons() {

        if (mStartTutorialButton != null && mStartTestButton != null) {

            mStartTutorialButton.setEnabled(true);
            mStartTestButton.setEnabled(true);

        }

    }

    /* End of Introduction */

}
