package co.britehealth.android.assessment.framework;

import android.os.Bundle;
import android.support.v4.app.Fragment;

import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.BriteHealthViewPager;
import co.britehealth.android.assessment.common.PauseScreenFragment;
import co.britehealth.android.assessment.common.PauseScreenListener;


public abstract class BaseTestView extends Fragment
        implements
        TestCallbacks,
        PauseScreenListener {

    private BaseTestManager mTestManager;
    private boolean mPauseScreenVisible;
    private boolean mPaused;
    private int mRestarts;
    private BriteHealthViewPager mViewPager;
    private BriteHealthAssessmentActivity.ScreenSlidePagerAdapter mAdapter;
    private PauseScreenFragment mPauseScreenFragment;

    private boolean mPauseScreenActive;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        mPauseScreenVisible = false;
        mPaused = false;
        mRestarts = 0;

        mViewPager = ((BriteHealthAssessmentActivity) getActivity()).getViewPager();
        mViewPager.setEnabled(false);

        mAdapter = ((BriteHealthAssessmentActivity) getActivity()).getAdapter();

        mPauseScreenActive = true;

    }

    @Override
    public void onResume() {

        super.onResume();

        if (mPaused && !mPauseScreenVisible) {
            showPauseScreen();
        } else if (!mPaused && !mPauseScreenVisible) {

            if (mTestManager.isTestStarted()) {
                mTestManager.resumeTest(System.currentTimeMillis());
            } else {
                mTestManager.startTest(System.currentTimeMillis());
            }

        }

    }

    @Override
    public void onPause() {

        super.onPause();

        if (!mPaused) {

            mTestManager.pauseTest(System.currentTimeMillis());
            mPaused = true;

        }

    }

    protected void showPauseScreen() {

        if (mPauseScreenActive) {

            Bundle bundle = new Bundle();
            bundle.putInt("NUM_RESTARTS", mRestarts);

            mPauseScreenFragment = new PauseScreenFragment();
            mPauseScreenFragment.setArguments(bundle);
            mPauseScreenFragment.setPauseScreenListener(this);
            mPauseScreenFragment.setCancelable(false);
            mPauseScreenFragment.show(getFragmentManager(), null);

            mPaused = true;
            mPauseScreenVisible = true;

        }

    }

    protected void setTestManager(BaseTestManager testManager) {
        mTestManager = testManager;
    }

    protected BaseTestManager getTestManager() {
        return mTestManager;
    }

    public BriteHealthViewPager getViewPager() {
        return mViewPager;
    }

    public BriteHealthAssessmentActivity.ScreenSlidePagerAdapter getAdapter() {
        return mAdapter;
    }

    public void setRestarts(int restarts) {
        mRestarts = restarts;
    }

    public void setPauseScreenActive(boolean pauseScreenActive) {
        mPauseScreenActive = pauseScreenActive;
    }

    @Override
    public void onResumeClick() {

        if (mPauseScreenFragment != null) {
            mPauseScreenFragment.dismiss();
        }
        mPaused = false;
        mPauseScreenVisible = false;

    }

    @Override
    public void onTutorialClick() {

        if (mPauseScreenFragment != null) {
            mPauseScreenFragment.dismiss();
        }
        mPauseScreenVisible = false;

    }

    @Override
    public void onRestartClick() {

        if (mPauseScreenFragment != null) {
            mPauseScreenFragment.dismiss();
        }

        mRestarts++;
        mPauseScreenVisible = false;
        mTestManager.restartTest(System.currentTimeMillis());

    }

    @Override
    public void onQuitClick() {

        if (mPauseScreenFragment != null) {
            mPauseScreenFragment.dismiss();
        }
        mPauseScreenVisible = false;
        mViewPager.setEnabled(true);

    }

}
