package co.britehealth.android.assessment.framework;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

import java.util.Date;


public abstract class BaseTestModel implements Parcelable {

    public static final String EXTRA = "test_model_extra";

    private transient int mType;

    @SerializedName("user_id")
    private int mUserId;

    @SerializedName("start")
    private Date mStartDate;

    @SerializedName("end")
    private Date mFinishDate;

    @SerializedName("score")
    private double mScore;

    public BaseTestModel(int type) {
        mType = type;
    }

    public void setUserId(int userId) {
        mUserId = userId;
    }

    public void setStartDate(Date startDate) {
        mStartDate = startDate;
    }

    public void setFinishDate(Date finishDate) {
        mFinishDate = finishDate;
    }

    public void setScore(double score) {
        mScore = score;
    }

    public int getType() {
        return mType;
    }

    public int getUserId() {
        return mUserId;
    }

    public Date getStartDate() {
        return mStartDate;
    }

    public Date getFinishDate() {
        return mFinishDate;
    }

    public double getScore() {
        return mScore;
    }

    /* Parcelable */

    protected BaseTestModel(Parcel parcel) {

        mType = parcel.readInt();
        mUserId = parcel.readInt();
        mStartDate = new Date(parcel.readLong());
        mFinishDate = new Date(parcel.readLong());
        mScore = parcel.readDouble();

    }

    /* End of Parcelable */

}
