package co.britehealth.android.assessment.framework;

import android.content.Context;
import android.content.Intent;

import java.util.Date;

import co.britehealth.android.BriteHealthSdk;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.service.AssessmentService;


public class BaseTestManager {

    private Context mContext;
    private BaseTestModel mTestModel;
    private TestCallbacks mTestCallbacks;
    private boolean mTestStarted;

    protected BaseTestManager(Context context, TestCallbacks testCallbacks) {
        mContext = context;
        mTestCallbacks = testCallbacks;
    }

    public void setTestModel(BaseTestModel testModel) {
        mTestModel = testModel;
    }

    public void setTestCallbacks(TestCallbacks testCallbacks) {
        mTestCallbacks = testCallbacks;
    }

    protected void setTestStarted(boolean testStarted) {
        mTestStarted = testStarted;
    }

    protected Context getContext() {
        return mContext;
    }

    public BaseTestModel getTestModel() {
        return mTestModel;
    }

    protected TestCallbacks getTestCallbacks() {
        return mTestCallbacks;
    }

    public boolean isTestStarted() {
        return mTestStarted;
    }

    public void createTest() {

        mTestStarted = false;

        if (mTestCallbacks != null) {
            mTestCallbacks.onCreateTest();
        }

    }

    public void startTest(long startTime) {

        mTestStarted = true;

        if (mTestModel != null) {
            mTestModel.setStartDate(new Date(startTime));
        } else {
            throw new NullPointerException("TestModel needs to be set in createTest() before starting the test.");
        }

        if (mTestCallbacks != null) {
            mTestCallbacks.onStartTest(startTime);
        }

    }

    public void pauseTest(long pauseTime) {

        if (mTestCallbacks != null) {
            mTestCallbacks.onPauseTest(pauseTime);
        }

    }

    public void resumeTest(long resumeTime) {

        if (mTestCallbacks != null) {
            mTestCallbacks.onResumeTest(resumeTime);
        }

    }

    public void finishTest(long finishTime) {

        mTestModel.setFinishDate(new Date(finishTime));

        if (mTestCallbacks != null) {
            mTestCallbacks.onFinishTest(finishTime);
        }

        BaseTestScores baseTestScores = computeBasicTestScores();

        mTestModel.setScore(baseTestScores.getScore());

        if (mTestCallbacks != null) {
            mTestCallbacks.onDisplayTestScores(baseTestScores);
        }

        storeTestModel();

        mTestModel = null;
        mTestCallbacks = null;

    }

    public void restartTest(long restartTime) {

        if (mTestCallbacks != null) {
            mTestCallbacks.onRestartTest();
        }

        mTestModel = null;

        createTest();
        startTest(restartTime);

    }

    public BaseTestScores computeBasicTestScores() {
        return null;
    }

    public void storeTestModel() {

        if (mTestModel != null) {

            Intent intent = new Intent(mContext, AssessmentService.class);
            intent.putExtra(
                    BriteHealthSdk.EXTRA_API_KEY,
                    ((BriteHealthAssessmentActivity) mContext).getIntent().getStringExtra(BriteHealthSdk.EXTRA_API_KEY)
            );
            intent.putExtra(
                    BriteHealthSdk.EXTRA_DATA_SECRET,
                    ((BriteHealthAssessmentActivity) mContext).getIntent().getStringExtra(BriteHealthSdk.EXTRA_DATA_SECRET)
            );
            intent.putExtra(BaseTestModel.EXTRA, mTestModel);
            mContext.startService(intent);

        } else {
            throw new NullPointerException("TestModel cannot be stored.");
        }

    }

}
