package co.britehealth.android.assessment.dsst;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

import co.britehealth.android.R;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.ResponseView;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.BaseTestView;
import co.britehealth.android.model.data.DBContract;


public class TestView extends BaseTestView
        implements
        View.OnClickListener,
        Toolbar.OnMenuItemClickListener {

    private static final String SCREEN_NAME = "Number Picture Substitution: " + TestView.class.getSimpleName();
    private Tracker mTracker;

    private static final long NEXT_ASSESSMENT_DELAY = 2 * 7 * 24 * 60 * 60 * 1000;

    private ImageView mMainImageView;
    private TextView mCounterTextView;
    private TextView mTimerTextView;
    private ResponseView mResponseView;
    private CardView mCardView;

    private Random mRandom;
    private int mRandomInt;
    private CountDownTimer mCountdownTimer;

    private long currentTick;
    private boolean mRestarted;

    private AlphaAnimation mResponseAlphaAnimation;

    private TranslateAnimation mTranslateAnimationIntro;
    private TranslateAnimation mTranslateAnimationOutro;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        BriteHealthAssessmentActivity activity = (BriteHealthAssessmentActivity) getActivity();
        mTracker = activity.getDefaultTracker();

        mRestarted = false;

        setTestManager(
                new TestManager(getActivity(), this)
        );
        getTestManager().createTest();

        int screenWidth;

        if (android.os.Build.VERSION.SDK_INT < 10) {

            Display display = getActivity().getWindowManager().getDefaultDisplay();
            screenWidth = display.getWidth();

        } else {

            DisplayMetrics metrics = new DisplayMetrics();
            getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
            screenWidth = metrics.widthPixels;

        }

        mTranslateAnimationIntro = new TranslateAnimation(screenWidth, 0, 0, 0);
        mTranslateAnimationIntro.setDuration(200);

        mTranslateAnimationOutro = new TranslateAnimation(0, -screenWidth, 0, 0);
        mTranslateAnimationOutro.setDuration(200);

        mResponseAlphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        mResponseAlphaAnimation.setDuration(333);
        mResponseAlphaAnimation.setRepeatMode(Animation.REVERSE);

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_dsst, container, false);

        Toolbar mToolbar = (Toolbar) rootView.findViewById(R.id.co_britehealth_android_toolbar);
        mToolbar.inflateMenu(R.menu.co_britehealth_android_test);
        mToolbar.setOnMenuItemClickListener(this);

        mCounterTextView = (TextView) mToolbar.findViewById(R.id.co_britehealth_android_counter_textView);
        mCounterTextView.setText(String.format("%02d", ((TestManager) getTestManager()).getNumTrials()));

        mTimerTextView = (TextView) mToolbar.findViewById(R.id.co_britehealth_android_timer_textView);
        mCountdownTimer = new CountDownTimer(45000, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {
                getTestManager().finishTest(System.currentTimeMillis());
            }

        };

        setupPictures(rootView);
        mCardView = (CardView) rootView.findViewById(R.id.co_britehealth_android_cardView_container);
        mMainImageView = (ImageView) mCardView.findViewById(R.id.main_imageView);
        setupButtons(rootView);

        mResponseView = (ResponseView) rootView.findViewById(R.id.co_britehealth_android_responseView);

        return rootView;

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.DSST_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.DSST_NUM_QUITS_KEY, 0);
        setRestarts(numQuits);

    }

    /* View.OnClickListener */

    @Override
    public void onClick(View v) {

        Button button = (Button) v;
        int tag = (int) button.getTag();

        boolean userIsCorrect = ((TestManager) getTestManager()).setUserAnswer(mRandomInt, tag);

        if (userIsCorrect) {
            mResponseView.setType(ResponseView.CORRECT);
        } else {
            mResponseView.setType(ResponseView.WRONG);
        }

        mResponseView.startAnimation(mResponseAlphaAnimation);

        mCardView.startAnimation(mTranslateAnimationOutro);
        mTranslateAnimationOutro.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {

                mRandomInt = mRandom.nextInt(TestManager.NUM_PICTURES);
                mMainImageView.setImageResource(((TestManager) getTestManager()).getPhotoId(mRandomInt));
                mCounterTextView.setText(String.format("%02d", ((TestManager) getTestManager()).getNumTrials()));
                mCardView.startAnimation(mTranslateAnimationIntro);

            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });

    }

    /* End of View.OnClickListener */

    /* TestCallbacks */

    @Override
    public void onCreateTest() {

        mRandom = new Random();

        if (mRestarted) {

            setupPictures(getView());
            setupButtons(getView());

        }

    }

    @Override
    public void onStartTest(long startTime) {

        mRandomInt = mRandom.nextInt(TestManager.NUM_PICTURES);
        mMainImageView.setImageResource(((TestManager) getTestManager()).getPhotoId(mRandomInt));

        mCountdownTimer.start();

    }

    @Override
    public void onPauseTest(long pauseTime) {
        mCountdownTimer.cancel();
        mCountdownTimer = null;
    }

    @Override
    public void onResumeTest(long resumeTime) {

        mMainImageView.setImageResource(((TestManager) getTestManager()).getPhotoId(mRandomInt));

        mCountdownTimer = new CountDownTimer(currentTick, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {
                getTestManager().finishTest(System.currentTimeMillis());
            }

        };

        mCountdownTimer.start();

    }

    @Override
    public void onFinishTest(long finishTime) {

    }

    @Override
    public void onRestartTest() {

        mRestarted = true;
        mCounterTextView.setText("00");
        mCountdownTimer = new CountDownTimer(45000, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {
                getTestManager().finishTest(System.currentTimeMillis());
            }

        };

    }

    @Override
    public void onDisplayTestScores(BaseTestScores baseTestScores) {

        long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

        getActivity().getContentResolver().delete(
                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                DBContract.NextAssessmentTimesTable._ID + " = ?",
                new String[]{String.valueOf(TestModel.TYPE)}
        );

        ContentValues values = new ContentValues();
        values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
        values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, baseTestScores.getScore());
        values.put(
                DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                nextTime
        );

        getActivity()
                .getContentResolver()
                .insert(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        values
                );

        Introduction introduction = (Introduction) getAdapter().getFragmentList().get(3);
        introduction.showScore(baseTestScores.getScore());
        introduction.showNextAssessment(nextTime);

        getViewPager().setEnabled(true);

        getFragmentManager()
                .beginTransaction()
                .remove(this)
                .commit();

    }

    /* End of TestCallbacks */

    /* PauseScreenListener */

    @Override
    public void onResumeClick() {

        super.onResumeClick();
        getTestManager().resumeTest(System.currentTimeMillis());

    }

    @Override
    public void onRestartClick() {

        super.onRestartClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.DSST_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.DSST_NUM_QUITS_KEY, 0);
        numQuits++;

        preferences.edit()
                .putInt(TestManager.DSST_NUM_QUITS_KEY, numQuits)
                .apply();

    }

    @Override
    public void onTutorialClick() {

        super.onTutorialClick();

        getFragmentManager()
                .beginTransaction()
                .addToBackStack(null)
                .replace(R.id.co_britehealth_android_container_main, new Tutorial())
                .commit();

    }

    @Override
    public void onQuitClick() {

        super.onQuitClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.DSST_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.DSST_NUM_QUITS_KEY, 0);

        if (numQuits >= 1) {

            long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

            Cursor cursor = getActivity()
                    .getContentResolver()
                    .query(
                            DBContract.NextAssessmentTimesTable.CONTENT_URI,
                            null,
                            DBContract.NextAssessmentTimesTable._ID + " = ?",
                            new String[]{String.valueOf(TestModel.TYPE)},
                            null
                    );

            int score = 0;

            if (cursor.moveToFirst()) {

                score = cursor.getInt(
                        cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
                );

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, score);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .update(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values,
                                DBContract.NextAssessmentTimesTable._ID + " = ?",
                                new String[]{String.valueOf(TestModel.TYPE)}
                        );

            } else {

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, -1);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .insert(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values
                        );

            }

            cursor.close();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(3);
            introduction.showScore(score);
            introduction.showNextAssessment(nextTime);

            getViewPager().setEnabled(true);

            preferences.edit()
                    .putInt(TestManager.DSST_NUM_QUITS_KEY, 0)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

        } else {

            numQuits++;
            preferences.edit()
                    .putInt(TestManager.DSST_NUM_QUITS_KEY, numQuits)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(3);
            introduction.enableButtons();

            ((BriteHealthAssessmentActivity) getActivity()).showIntroduction(3);

        }

    }

    /* End of PauseScreenListener */

    /* Toolbar.OnMenuItemClickListener */

    @Override
    public boolean onMenuItemClick(MenuItem item) {

        getTestManager().pauseTest(System.currentTimeMillis());
        showPauseScreen();

        return true;

    }

    /* End of Toolbar.OnMenuItemClickListener */

    /* TestView */

    private void setupPictures(View rootView) {

        ImageView imageViewOne = (ImageView) rootView.findViewById(R.id.picture_one);
        imageViewOne.setImageResource(changeBlackToWhite(((TestManager) getTestManager()).getPhotoId(0)));

        ImageView imageViewTwo = (ImageView) rootView.findViewById(R.id.picture_two);
        imageViewTwo.setImageResource(changeBlackToWhite(((TestManager) getTestManager()).getPhotoId(1)));

        ImageView imageViewThree = (ImageView) rootView.findViewById(R.id.picture_three);
        imageViewThree.setImageResource(changeBlackToWhite(((TestManager) getTestManager()).getPhotoId(2)));

        ImageView imageViewFour = (ImageView) rootView.findViewById(R.id.picture_four);
        imageViewFour.setImageResource(changeBlackToWhite(((TestManager) getTestManager()).getPhotoId(3)));

        ImageView imageViewFive = (ImageView) rootView.findViewById(R.id.picture_five);
        imageViewFive.setImageResource(changeBlackToWhite(((TestManager) getTestManager()).getPhotoId(4)));

        ImageView imageViewSix = (ImageView) rootView.findViewById(R.id.picture_six);
        imageViewSix.setImageResource(changeBlackToWhite(((TestManager) getTestManager()).getPhotoId(5)));

        ImageView imageViewSeven = (ImageView) rootView.findViewById(R.id.picture_seven);
        imageViewSeven.setImageResource(changeBlackToWhite(((TestManager) getTestManager()).getPhotoId(6)));

        ImageView imageViewEight = (ImageView) rootView.findViewById(R.id.picture_eight);
        imageViewEight.setImageResource(changeBlackToWhite(((TestManager) getTestManager()).getPhotoId(7)));

    }

    private void setupButtons(View rootView) {

        ArrayList<Integer> numbersList = new ArrayList<>();
        for (int i = 0; i < 8; i++) {
            numbersList.add(i + 1);
        }
        Collections.shuffle(numbersList);

        Button buttonOne = (Button) rootView.findViewById(R.id.button_one);
        buttonOne.setText(numbersList.get(0).toString());
        buttonOne.setTag(numbersList.get(0) - 1);
        buttonOne.setOnClickListener(this);

        Button buttonTwo = (Button) rootView.findViewById(R.id.button_two);
        buttonTwo.setText(numbersList.get(1).toString());
        buttonTwo.setTag(numbersList.get(1) - 1);
        buttonTwo.setOnClickListener(this);

        Button buttonThree = (Button) rootView.findViewById(R.id.button_three);
        buttonThree.setText(numbersList.get(2).toString());
        buttonThree.setTag(numbersList.get(2) - 1);
        buttonThree.setOnClickListener(this);

        Button buttonFour = (Button) rootView.findViewById(R.id.button_four);
        buttonFour.setText(numbersList.get(3).toString());
        buttonFour.setTag(numbersList.get(3) - 1);
        buttonFour.setOnClickListener(this);

        Button buttonFive = (Button) rootView.findViewById(R.id.button_five);
        buttonFive.setText(numbersList.get(4).toString());
        buttonFive.setTag(numbersList.get(4) - 1);
        buttonFive.setOnClickListener(this);

        Button buttonSix = (Button) rootView.findViewById(R.id.button_six);
        buttonSix.setText(numbersList.get(5).toString());
        buttonSix.setTag(numbersList.get(5) - 1);
        buttonSix.setOnClickListener(this);

        Button buttonSeven = (Button) rootView.findViewById(R.id.button_seven);
        buttonSeven.setText(numbersList.get(6).toString());
        buttonSeven.setTag(numbersList.get(6) - 1);
        buttonSeven.setOnClickListener(this);

        Button buttonEight = (Button) rootView.findViewById(R.id.button_eight);
        buttonEight.setText(numbersList.get(7).toString());
        buttonEight.setTag(numbersList.get(7) - 1);
        buttonEight.setOnClickListener(this);

    }

    private int changeBlackToWhite(int id) {

        if (id == R.drawable.bear_black) {
            return R.drawable.bear_white;
        } else if (id == R.drawable.car_black) {
            return R.drawable.car_white;
        } else if (id == R.drawable.coin_black) {
            return R.drawable.coin_white;
        } else if (id == R.drawable.eye_black) {
            return R.drawable.eye_white;
        } else if (id == R.drawable.house_black) {
            return R.drawable.house_white;
        } else if (id == R.drawable.needle_black) {
            return R.drawable.needle_white;
        } else if (id == R.drawable.puppy_black) {
            return R.drawable.puppy_white;
        } else if (id == R.drawable.tongue_black) {
            return R.drawable.tongue_white;
        }

        return -1;

    }

    /* End of TestView */

}
