package co.britehealth.android.assessment.dsst;

import android.os.Parcel;

import com.google.gson.annotations.SerializedName;

import co.britehealth.android.assessment.framework.BaseTestModel;


public class TestModel extends BaseTestModel {

    public static final int TYPE = 4;

    @SerializedName("num_trials")
    private int mNumTrials;

    @SerializedName("num_correct")
    private int mNumCorrect;

    @SerializedName("num_wrong")
    private int mNumWrong;

    public TestModel(int type) {

        super(type);

        mNumTrials = 0;
        mNumCorrect = 0;
        mNumWrong = 0;

    }

    public void setNumTrials(int numTrials) {
        mNumTrials = numTrials;
    }

    public void setNumCorrect(int numCorrect) {
        mNumCorrect = numCorrect;
    }

    public void setNumWrong(int numWrong) {
        mNumWrong = numWrong;
    }

    public int getNumTrials() {
        return mNumTrials;
    }

    public int getNumCorrect() {
        return mNumCorrect;
    }

    public int getNumWrong() {
        return mNumWrong;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeInt(getType());
        dest.writeInt(getUserId());
        dest.writeLong(getStartDate().getTime());
        dest.writeLong(getFinishDate().getTime());
        dest.writeDouble(getScore());
        dest.writeInt(mNumTrials);
        dest.writeInt(mNumCorrect);
        dest.writeInt(mNumWrong);

    }

    public static final Creator<TestModel> CREATOR = new Creator<TestModel>() {

        @Override
        public TestModel createFromParcel(Parcel source) {
            return new TestModel(source);
        }

        @Override
        public TestModel[] newArray(int size) {
            return new TestModel[size];
        }

    };

    protected TestModel(Parcel parcel) {

        super(parcel);
        mNumTrials = parcel.readInt();
        mNumCorrect = parcel.readInt();
        mNumWrong = parcel.readInt();

    }

}
