package co.britehealth.android.assessment.dsst;

import android.content.Context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import co.britehealth.android.BriteHealthException;
import co.britehealth.android.R;
import co.britehealth.android.assessment.framework.BaseTestManager;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.TestCallbacks;
import co.britehealth.android.util.DatabaseUtils;


public class TestManager extends BaseTestManager {

    public static final int[] PICTURES_ID = {
            R.drawable.bear_black,
            R.drawable.car_black,
            R.drawable.coin_black,
            R.drawable.eye_black,
            R.drawable.house_black,
            R.drawable.needle_black,
            R.drawable.puppy_black,
            R.drawable.tongue_black
    };

    public static final String DSST_NUM_QUITS = "co_britehealth_android_dsst_num_quits";
    public static final String DSST_NUM_QUITS_KEY = "co_britehealth_android_dsst_num_quits_key";

    public static final int NUM_PICTURES = 8;

    private List<Integer> mRandomPictures;

    protected TestManager(Context context, TestCallbacks testCallbacks) {
        super(context, testCallbacks);
    }

    @Override
    public TestModel getTestModel() {
        return (TestModel) super.getTestModel();
    }

    public int getPhotoId(int location) {
        return mRandomPictures.get(location);
    }

    public boolean setUserAnswer(int correct, int answer) {

        getTestModel().setNumTrials(getNumTrials() + 1);

        if (answer == correct) {
            getTestModel().setNumCorrect(getTestModel().getNumCorrect() + 1);
            return true;
        } else {
            getTestModel().setNumWrong(getTestModel().getNumWrong() + 1);
            return false;
        }

    }

    public int getNumTrials() {
        return getTestModel().getNumTrials();
    }

    @Override
    public void createTest() {

        TestModel testModel = new TestModel(TestModel.TYPE);
        setTestModel(testModel);

        int userId = DatabaseUtils.getCurrentUserId(getContext());
        if (userId != -1) {
            testModel.setUserId(userId);
        } else {

            throw new BriteHealthException(
                    "You need to register the current user with Brite Health before creating a test."
            );

        }

        mRandomPictures = new ArrayList<>();
        for (int i = 0; i < 8; i++) {
            mRandomPictures.add(PICTURES_ID[i]);
        }
        Collections.shuffle(mRandomPictures);

        super.createTest();

    }

    @Override
    public BaseTestScores computeBasicTestScores() {

        int score;

        score = getTestModel().getNumCorrect();

        if (score > 0) {

            float scores = (100f / 30f) * score;

            score = (int) scores;

            if (score > 100) {
                score = 100;
            }

        }

        TestScores testScores = new TestScores();
        testScores.setScore(score);
        return testScores;

    }

}
