package co.britehealth.android.assessment.dissimilar.shapes;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;
import java.util.List;

import co.britehealth.android.R;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.BriteHealthViewPager;
import co.britehealth.android.assessment.common.DotsProgressBar;


public class Tutorial extends Fragment implements ViewPager.OnPageChangeListener {

    private static final String SCREEN_NAME = "DSST: " + Tutorial.class.getSimpleName();
    private Tracker mTracker;

    private DotsProgressBar mDotsProgressBar;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        BriteHealthAssessmentActivity activity = (BriteHealthAssessmentActivity) getActivity();
        mTracker = activity.getDefaultTracker();

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_tutorial, container, false);

        BriteHealthViewPager mBriteHealthViewPager =
                (BriteHealthViewPager) rootView.findViewById(R.id.co_britehealth_android_view_pager);
        ScreenSlidePagerAdapter adapter = new ScreenSlidePagerAdapter(getChildFragmentManager());
        mBriteHealthViewPager.setAdapter(adapter);
        mBriteHealthViewPager.addOnPageChangeListener(this);

        mDotsProgressBar =
                (DotsProgressBar) rootView.findViewById(R.id.co_britehealth_android_dots_progressBar);
        mDotsProgressBar.setSize(2);
        mDotsProgressBar.setCurrent(1);

        TextView skipTutorial = (TextView) rootView.findViewById(R.id.co_britehealth_android_skip_tutorial);
        skipTutorial.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getFragmentManager().popBackStack();
            }
        });

        return rootView;

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

    }

    @Override
    public void onPageSelected(int position) {
        mDotsProgressBar.setCurrent(position + 1);
    }

    @Override
    public void onPageScrollStateChanged(int state) {

    }

    public class ScreenSlidePagerAdapter extends FragmentStatePagerAdapter {

        private static final int NUM_FRAGMENTS = 2;
        private List<Fragment> mFragmentList;

        public ScreenSlidePagerAdapter(FragmentManager fm) {

            super(fm);

            mFragmentList = new ArrayList<>();
            mFragmentList.add(new TutorialOne());
            mFragmentList.add(new TutorialTwo());

        }

        @Override
        public Fragment getItem(int position) {
            return mFragmentList.get(position);
        }

        @Override
        public int getCount() {
            return NUM_FRAGMENTS;
        }

    }

}
