package co.britehealth.android.assessment.dissimilar.shapes;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

import co.britehealth.android.R;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.BriteHealthShape;
import co.britehealth.android.assessment.common.ResponseView;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.BaseTestView;


public class TestViewB extends BaseTestView
        implements
        Toolbar.OnMenuItemClickListener {

    private static final String SCREEN_NAME = "Dissimilar Shapes: " + TestViewB.class.getSimpleName();
    private Tracker mTracker;

    private static final int COUNTDOWN_INITIAL_VALUE = 20; // Seconds

    private TextView mCounterTextView;
    private TextView mTimerTextView;
    private CountDownTimer mCountdownTimer;
    private long currentTick;

    private SelectShapeListener mListener;

    private ResponseView mResponseView;
    private int mId;
    private AlphaAnimation mAlphaAnimation;

    private Date mStartDate;

    private Handler mHandler;
    private Runnable mRunnable;
    private long mStartTime;
    private long mTimeInMilliseconds;
    private long mTimeBuffer;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        BriteHealthAssessmentActivity activity = (BriteHealthAssessmentActivity) getActivity();
        mTracker = activity.getDefaultTracker();

        setTestManager(
                new TestManager(getActivity(), this)
        );
        getTestManager().createTest();

        createProgressTimer();

        mAlphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        mAlphaAnimation.setDuration(333);
        mAlphaAnimation.setRepeatMode(Animation.REVERSE);
        mAlphaAnimation.setAnimationListener(new Animation.AnimationListener() {

            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                goBack(mId);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }

        });

        mStartDate = new Date(System.currentTimeMillis());

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_dissimilar_shapes_b, container, false);

        Toolbar toolbar = (Toolbar) rootView.findViewById(R.id.co_britehealth_android_toolbar);
        toolbar.inflateMenu(R.menu.co_britehealth_android_test);
        toolbar.setOnMenuItemClickListener(this);

        mCounterTextView = (TextView) toolbar.findViewById(R.id.co_britehealth_android_counter_textView);
        mCounterTextView.setText((getArguments().getInt("location") + 1) + "/10");

        mTimerTextView = (TextView) toolbar.findViewById(R.id.co_britehealth_android_timer_textView);
        mCountdownTimer = new CountDownTimer(COUNTDOWN_INITIAL_VALUE * 1000, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {

                mId = 11;
                mResponseView.setType(ResponseView.WRONG);
                mResponseView.startAnimation(mAlphaAnimation);

            }

        };

        final ArrayList<GeneralizedShape> generalizedShapes =
                getArguments().getParcelableArrayList("generalized_shapes");

        if (generalizedShapes != null) {

            Collections.shuffle(generalizedShapes);

            LinearLayout shapeContainerOne =
                    (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_container_shape_1);
            CardView cardViewOne =
                    (CardView) rootView.findViewById(R.id.co_britehealth_android_container_card_1);
            cardViewOne.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    mId = generalizedShapes.get(0).getId();
                    if (mId == 10) {
                        mResponseView.setType(ResponseView.CORRECT);
                    } else {
                        mResponseView.setType(ResponseView.WRONG);
                    }
                    mResponseView.startAnimation(mAlphaAnimation);

                }
            });

            for (int i = 0; i < generalizedShapes.get(0).getNumber(); i++) {

                BriteHealthShape briteHealthShape = new BriteHealthShape(getActivity());
                briteHealthShape.setProperties(
                        generalizedShapes.get(0).getType(),
                        generalizedShapes.get(0).getColor(),
                        generalizedShapes.get(0).getPattern()
                );

                shapeContainerOne.addView(briteHealthShape, 200, 200);

            }

            LinearLayout mShapeContainerTwo =
                    (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_container_shape_2);
            CardView cardViewTwo =
                    (CardView) rootView.findViewById(R.id.co_britehealth_android_container_card_2);
            cardViewTwo.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    mId = generalizedShapes.get(1).getId();
                    if (mId == 10) {
                        mResponseView.setType(ResponseView.CORRECT);
                    } else {
                        mResponseView.setType(ResponseView.WRONG);
                    }
                    mResponseView.startAnimation(mAlphaAnimation);

                }
            });

            for (int i = 0; i < generalizedShapes.get(1).getNumber(); i++) {

                BriteHealthShape briteHealthShape = new BriteHealthShape(getActivity());
                briteHealthShape.setProperties(
                        generalizedShapes.get(1).getType(),
                        generalizedShapes.get(1).getColor(),
                        generalizedShapes.get(1).getPattern()
                );

                mShapeContainerTwo.addView(briteHealthShape, 200, 200);

            }

            LinearLayout mShapeContainer3 = (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_container_shape_3);
            CardView cardView3 = (CardView) rootView.findViewById(R.id.co_britehealth_android_container_card_3);
            cardView3.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    mId = generalizedShapes.get(2).getId();
                    if (mId == 10) {
                        mResponseView.setType(ResponseView.CORRECT);
                    } else {
                        mResponseView.setType(ResponseView.WRONG);
                    }
                    mResponseView.startAnimation(mAlphaAnimation);

                }
            });

            for (int i = 0; i < generalizedShapes.get(2).getNumber(); i++) {

                BriteHealthShape briteHealthShape = new BriteHealthShape(getActivity());
                briteHealthShape.setProperties(
                        generalizedShapes.get(2).getType(),
                        generalizedShapes.get(2).getColor(),
                        generalizedShapes.get(2).getPattern()
                );

                mShapeContainer3.addView(briteHealthShape, 200, 200);

            }

        }

        mResponseView = (ResponseView) rootView.findViewById(R.id.co_britehealth_android_responseView);

        return rootView;

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.DISSIMILAR_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.DISSIMILAR_NUM_QUITS_KEY, 0);
        setRestarts(numQuits);

    }

    /* TestCallbacks */

    @Override
    public void onCreateTest() {

    }

    @Override
    public void onStartTest(long startTime) {

        mCountdownTimer.start();
        startProgressTimer();

    }

    @Override
    public void onPauseTest(long pauseTime) {

        stopProgressTimer();

        mCountdownTimer.cancel();
        mCountdownTimer = null;

    }

    @Override
    public void onResumeTest(long resumeTime) {

        startProgressTimer();

        mCountdownTimer = new CountDownTimer(currentTick, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {

                mId = 11;
                mResponseView.setType(ResponseView.WRONG);
                mResponseView.startAnimation(mAlphaAnimation);

            }

        };

        mCountdownTimer.start();

    }

    @Override
    public void onFinishTest(long finishTime) {

    }

    @Override
    public void onRestartTest() {

        mCountdownTimer = new CountDownTimer(COUNTDOWN_INITIAL_VALUE * 1000, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {

                mId = 11;
                mResponseView.setType(ResponseView.WRONG);
                mResponseView.startAnimation(mAlphaAnimation);

            }

        };

        mCountdownTimer.start();

    }

    @Override
    public void onDisplayTestScores(BaseTestScores baseTestScores) {

    }

    /* End of TestCallbacks */

    /* PauseScreenListener */

    @Override
    public void onResumeClick() {

        super.onResumeClick();
        getTestManager().resumeTest(System.currentTimeMillis());

    }

    @Override
    public void onTutorialClick() {

        super.onTutorialClick();
        goBack(400);

    }

    @Override
    public void onRestartClick() {

        super.onRestartClick();
        goBack(500);

    }

    @Override
    public void onQuitClick() {

        super.onQuitClick();
        goBack(600);

    }

    /* End of PauseScreenListener */

    /* Toolbar.OnMenuItemClickListener */

    @Override
    public boolean onMenuItemClick(MenuItem item) {

        getTestManager().pauseTest(System.currentTimeMillis());
        showPauseScreen();

        return true;

    }

    /* End of Toolbar.OnMenuItemClickListener  */

    /* TestViewB */

    private void goBack(int id) {

        stopProgressTimer();
        mListener.shapeSelected(id, mStartDate, new Date(System.currentTimeMillis()), mTimeBuffer);

        getFragmentManager()
                .beginTransaction()
                .remove(this)
                .commit();

    }

    public void setSelectShapeListener(SelectShapeListener listener) {
        mListener = listener;
    }

    /* End of TestViewB */

    private void createProgressTimer() {

        mHandler = new Handler();
        mRunnable = new Runnable() {

            @Override
            public void run() {

                mTimeInMilliseconds = SystemClock.uptimeMillis() - mStartTime;
                mHandler.postDelayed(this, 0);

            }

        };

    }

    private void startProgressTimer() {

        mStartTime = SystemClock.uptimeMillis();
        mHandler.postDelayed(mRunnable, 0);

    }

    private void stopProgressTimer() {

        mTimeBuffer += mTimeInMilliseconds;
        mHandler.removeCallbacks(mRunnable);

    }

}
