package co.britehealth.android.assessment.dissimilar.shapes;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;
import java.util.Date;

import co.britehealth.android.R;
import co.britehealth.android.assessment.BriteHealthAssessmentActivity;
import co.britehealth.android.assessment.common.BriteHealthShape;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.BaseTestView;
import co.britehealth.android.model.data.DBContract;


public class TestViewA extends BaseTestView
        implements
        SelectShapeListener,
        Toolbar.OnMenuItemClickListener {

    private static final String SCREEN_NAME = "Dissimilar Shapes: " + TestViewA.class.getSimpleName();
    private Tracker mTracker;

    private static final long NEXT_ASSESSMENT_DELAY = 2 * 7 * 24 * 60 * 60 * 1000;
    private static final int COUNTDOWN_INITIAL_VALUE = 10; // Seconds

    private TextView mCounterTextView;
    private TextView mTimerTextView;
    private CountDownTimer mCountdownTimer;
    private long currentTick;

    private LinearLayout mLayout;
    private LinearLayout mShapeContainer;
    private CardView mCardView;

    private int mLocation;
    private int mNumCorrect;
    private int mNumWrong;

    private boolean mRestarted;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        BriteHealthAssessmentActivity activity = (BriteHealthAssessmentActivity) getActivity();
        mTracker = activity.getDefaultTracker();

        mRestarted = false;

        setTestManager(
                new TestManager(getActivity(), this)
        );
        getTestManager().createTest();

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_dissimilar_shapes_a, container, false);

        Toolbar toolbar = (Toolbar) rootView.findViewById(R.id.co_britehealth_android_toolbar);
        toolbar.inflateMenu(R.menu.co_britehealth_android_test);
        toolbar.setOnMenuItemClickListener(this);

        mCounterTextView = (TextView) toolbar.findViewById(R.id.co_britehealth_android_counter_textView);
        mCounterTextView.setText((mLocation + 1) + "/10");

        mTimerTextView = (TextView) toolbar.findViewById(R.id.co_britehealth_android_timer_textView);
        mCountdownTimer = new CountDownTimer(COUNTDOWN_INITIAL_VALUE * 1000, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {
                launchTestViewB();
            }

        };

        setupShapes(rootView);

        return rootView;

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.DISSIMILAR_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.DISSIMILAR_NUM_QUITS_KEY, 0);
        setRestarts(numQuits);

    }

    /* TestCallbacks */

    @Override
    public void onCreateTest() {

        if (mRestarted) {
            setupShapes(getView());
        }

    }

    @Override
    public void onStartTest(long startTime) {
        mCountdownTimer.start();
    }

    @Override
    public void onPauseTest(long pauseTime) {

        if (mCountdownTimer != null) {

            mCountdownTimer.cancel();
            mCountdownTimer = null;

        }

    }

    @Override
    public void onResumeTest(long resumeTime) {

        mCountdownTimer = new CountDownTimer(currentTick, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {
                launchTestViewB();
            }

        };

        mCountdownTimer.start();

    }

    @Override
    public void onFinishTest(long finishTime) {
        mLayout.setOnClickListener(null);
    }

    @Override
    public void onRestartTest() {

        mRestarted = true;

        mLocation = 0;
        mNumCorrect = 0;
        mNumWrong = 0;
        mCounterTextView.setText("1/10");

        mShapeContainer.removeAllViews();

        mCountdownTimer = new CountDownTimer(COUNTDOWN_INITIAL_VALUE * 1000, 1000) {

            @Override
            public void onTick(long millisUntilFinished) {
                mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                currentTick = millisUntilFinished;
            }

            @Override
            public void onFinish() {
                launchTestViewB();
            }

        };

        mCountdownTimer.start();

    }

    @Override
    public void onDisplayTestScores(BaseTestScores baseTestScores) {

        long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

        getActivity().getContentResolver().delete(
                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                DBContract.NextAssessmentTimesTable._ID + " = ?",
                new String[]{String.valueOf(TestModel.TYPE)}
        );

        ContentValues values = new ContentValues();
        values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
        values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, baseTestScores.getScore());
        values.put(
                DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                nextTime
        );

        getActivity()
                .getContentResolver()
                .insert(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        values
                );

        Introduction introduction = (Introduction) getAdapter().getFragmentList().get(4);
        introduction.showScore(baseTestScores.getScore());
        introduction.showNextAssessment(nextTime);

        getViewPager().setEnabled(true);

        getFragmentManager()
                .beginTransaction()
                .remove(this)
                .commit();

    }

    /* End of TestCallbacks */

    /* PauseScreenListener */

    @Override
    public void onResumeClick() {

        super.onResumeClick();
        getTestManager().resumeTest(System.currentTimeMillis());

    }

    @Override
    public void onTutorialClick() {

        super.onTutorialClick();

        getFragmentManager()
                .beginTransaction()
                .addToBackStack(null)
                .replace(R.id.co_britehealth_android_container_main, new Tutorial())
                .commit();

    }

    @Override
    public void onRestartClick() {

        super.onRestartClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.DISSIMILAR_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.DISSIMILAR_NUM_QUITS_KEY, 0);
        numQuits++;

        preferences.edit()
                .putInt(TestManager.DISSIMILAR_NUM_QUITS_KEY, numQuits)
                .apply();

    }

    @Override
    public void onQuitClick() {

        super.onQuitClick();

        SharedPreferences preferences =
                getActivity().getSharedPreferences(TestManager.DISSIMILAR_NUM_QUITS, Context.MODE_PRIVATE);

        int numQuits = preferences.getInt(TestManager.DISSIMILAR_NUM_QUITS_KEY, 0);

        if (numQuits >= 1) {

            long nextTime = System.currentTimeMillis() + NEXT_ASSESSMENT_DELAY;

            Cursor cursor = getActivity()
                    .getContentResolver()
                    .query(
                            DBContract.NextAssessmentTimesTable.CONTENT_URI,
                            null,
                            DBContract.NextAssessmentTimesTable._ID + " = ?",
                            new String[]{String.valueOf(TestModel.TYPE)},
                            null
                    );

            int score = 0;

            if (cursor.moveToFirst()) {

                score = cursor.getInt(
                        cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
                );

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, score);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .update(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values,
                                DBContract.NextAssessmentTimesTable._ID + " = ?",
                                new String[]{String.valueOf(TestModel.TYPE)}
                        );

            } else {

                ContentValues values = new ContentValues();
                values.put(DBContract.NextAssessmentTimesTable._ID, TestModel.TYPE);
                values.put(DBContract.NextAssessmentTimesTable.COLUMN_SCORE, -1);
                values.put(
                        DBContract.NextAssessmentTimesTable.COLUMN_NEXT_ASSESSMENT_TIME,
                        nextTime
                );

                getActivity()
                        .getContentResolver()
                        .insert(
                                DBContract.NextAssessmentTimesTable.CONTENT_URI,
                                values
                        );

            }

            cursor.close();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(4);
            introduction.showScore(score);
            introduction.showNextAssessment(nextTime);

            getViewPager().setEnabled(true);

            preferences.edit()
                    .putInt(TestManager.DISSIMILAR_NUM_QUITS_KEY, 0)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

        } else {

            numQuits++;
            preferences.edit()
                    .putInt(TestManager.DISSIMILAR_NUM_QUITS_KEY, numQuits)
                    .apply();

            getFragmentManager()
                    .beginTransaction()
                    .remove(this)
                    .commit();

            Introduction introduction = (Introduction) getAdapter().getFragmentList().get(4);
            introduction.enableButtons();

            ((BriteHealthAssessmentActivity) getActivity()).showIntroduction(4);

        }

    }

    /* End of PauseScreenListener */

    /* SelectShapeListener */

    @Override
    public void shapeSelected(int id, Date startDate, Date endDate, long processingTime) {

        mLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                launchTestViewB();
            }
        });
        setPauseScreenActive(true);

        if (id == 400) {

            onTutorialClick();

        } else if (id == 500) {

            onRestartClick();

        } else if (id == 600) {

            onQuitClick();

        } else {

            int isCorrect;

            if (id == 10) {
                isCorrect = 1;
                mNumCorrect++;
                ((TestManager) getTestManager()).setNumCorrect(mNumCorrect);
            } else {
                isCorrect = 0;
                mNumWrong++;
                ((TestManager) getTestManager()).setNumWrong(mNumWrong);
            }

            ((TestManager) getTestManager()).setTrialStartTime(startDate, mLocation);
            ((TestManager) getTestManager()).setTrialFinishTime(endDate, mLocation);
            ((TestManager) getTestManager()).setProcessingTime(processingTime, mLocation);
            ((TestManager) getTestManager()).setCorrect(isCorrect, mLocation);

            mLocation++;

            if (mLocation < 10) {

                mCounterTextView.setText((mLocation + 1) + "/10");

                mShapeContainer.removeAllViews();

                for (int i = 0; i < ((TestManager) getTestManager()).getShownShapes().get(mLocation).getNumber(); i++) {

                    BriteHealthShape briteHealthShape = new BriteHealthShape(getActivity());
                    briteHealthShape.setProperties(
                            ((TestManager) getTestManager()).getShownShapes().get(mLocation).getType(),
                            ((TestManager) getTestManager()).getShownShapes().get(mLocation).getColor(),
                            ((TestManager) getTestManager()).getShownShapes().get(mLocation).getPattern()
                    );

                    mShapeContainer.addView(briteHealthShape, 300, 300);

                }

                mCountdownTimer = new CountDownTimer(COUNTDOWN_INITIAL_VALUE * 1000, 1000) {

                    @Override
                    public void onTick(long millisUntilFinished) {
                        mTimerTextView.setText(String.format("00:%02d", ((millisUntilFinished + 200) / 1000)));
                        currentTick = millisUntilFinished;
                    }

                    @Override
                    public void onFinish() {
                        launchTestViewB();
                    }

                };

                mCountdownTimer.start();

            } else {

                getTestManager().finishTest(System.currentTimeMillis());

            }

        }

    }

    /* End of SelectShapeListener */

    /* Toolbar.OnMenuItemClickListener */

    @Override
    public boolean onMenuItemClick(MenuItem item) {

        getTestManager().pauseTest(System.currentTimeMillis());
        showPauseScreen();

        return true;

    }

    /* End of Toolbar.OnMenuItemClickListener  */

    /* TestViewA */

    private void launchTestViewB() {

        mLayout.setOnClickListener(null);
        setPauseScreenActive(false);

        if (mCountdownTimer != null) {

            mCountdownTimer.cancel();
            mCountdownTimer = null;

        }

        TestViewB testViewB = new TestViewB();
        testViewB.setSelectShapeListener(this);

        ArrayList<GeneralizedShape> generalizedShapes = new ArrayList<>();
        generalizedShapes.add(
                ((TestManager) getTestManager()).getTestTrials().get(mLocation).getFirstGeneralizedShape()
        );
        generalizedShapes.add(
                ((TestManager) getTestManager()).getTestTrials().get(mLocation).getSecondGeneralizedShape()
        );
        generalizedShapes.add(
                ((TestManager) getTestManager()).getTestTrials().get(mLocation).getThirdGeneralizedShape()
        );

        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("generalized_shapes", generalizedShapes);
        bundle.putInt("location", mLocation);

        testViewB.setArguments(bundle);

        getFragmentManager()
                .beginTransaction()
                .add(R.id.co_britehealth_android_container_main, testViewB)
                .commit();

    }

    private void setupShapes(View rootView) {

        mLayout = (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_cardView_linear_layout);
        mLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                launchTestViewB();
            }
        });

        mCardView = (CardView) rootView.findViewById(R.id.co_britehealth_android_container_card);

        mShapeContainer = (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_container_shape);

        for (int i = 0; i < ((TestManager) getTestManager()).getShownShapes().get(mLocation).getNumber(); i++) {

            BriteHealthShape briteHealthShape = new BriteHealthShape(getActivity());
            briteHealthShape.setProperties(
                    ((TestManager) getTestManager()).getShownShapes().get(mLocation).getType(),
                    ((TestManager) getTestManager()).getShownShapes().get(mLocation).getColor(),
                    ((TestManager) getTestManager()).getShownShapes().get(mLocation).getPattern()
            );

            mShapeContainer.addView(briteHealthShape, 300, 300);

        }


    }

    /* End of TestViewA */

}
