package co.britehealth.android.assessment.dissimilar.shapes;

import android.content.Context;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

import co.britehealth.android.BriteHealthException;
import co.britehealth.android.assessment.common.BriteHealthShape;
import co.britehealth.android.assessment.framework.BaseTestManager;
import co.britehealth.android.assessment.framework.BaseTestScores;
import co.britehealth.android.assessment.framework.TestCallbacks;
import co.britehealth.android.util.DatabaseUtils;


public class TestManager extends BaseTestManager {

    public static final int NUM_TRIALS = 10;

    public static final String DISSIMILAR_NUM_QUITS = "co_britehealth_android_dissimilar_num_quits";
    public static final String DISSIMILAR_NUM_QUITS_KEY = "co_britehealth_android_dissimilar_num_quits_key";

    private List<GeneralizedShape> mShownShapes;
    private List<TestTrial> mTestTrials;

    protected TestManager(Context context, TestCallbacks testCallbacks) {
        super(context, testCallbacks);
    }

    @Override
    public TestModel getTestModel() {
        return (TestModel) super.getTestModel();
    }

    public void setNumTrials(int numTrials) {
        getTestModel().setNumTrials(numTrials);
    }

    public void setNumCorrect(int numCorrect) {
        getTestModel().setNumCorrect(numCorrect);
    }

    public void setNumWrong(int numWrong) {
        getTestModel().setNumWrong(numWrong);
    }

    public List<GeneralizedShape> getShownShapes() {
        return mShownShapes;
    }

    public List<TestTrial> getTestTrials() {
        return mTestTrials;
    }

    public void setTrialStartTime(Date startTime, int location) {
        getTestModel().getTestDataList().get(location).setStartDate(startTime);
    }

    public void setTrialFinishTime(Date finishTime, int location) {
        getTestModel().getTestDataList().get(location).setFinishDate(finishTime);
    }

    public void setProcessingTime(long processingTime, int location) {
        getTestModel().getTestDataList().get(location).setProcessingTime(Math.min(processingTime, 20000));
    }

    public void setCorrect(int correct, int location) {
        getTestModel().getTestDataList().get(location).setCorrect(correct);
    }

    @Override
    public void createTest() {

        TestModel testModel = new TestModel(TestModel.TYPE);
        List<TestData> testDataList = new ArrayList<>();
        for (int i = 0; i < NUM_TRIALS; i++) {
            testDataList.add(new TestData(null, null, 0, 0));
        }
        testModel.setTestDataList(testDataList);

        int userId = DatabaseUtils.getCurrentUserId(getContext());
        if (userId != -1) {
            testModel.setUserId(userId);
        } else {

            throw new BriteHealthException(
                    "You need to register the current user with Brite Health before creating a test."
            );

        }

        mShownShapes = new ArrayList<>();
        mTestTrials = new ArrayList<>();
        Random random = new Random();

        for (int i = 0; i < NUM_TRIALS; i++) {

            // Generate shown shape
            BriteHealthShape.ShapeType shownType = BriteHealthShape.ShapeType.getRandom();
            BriteHealthShape.ShapeColor shownColor = BriteHealthShape.ShapeColor.getRandom();
            BriteHealthShape.ShapePattern shownPattern = BriteHealthShape.ShapePattern.getRandom();
            int shownNumber = random.nextInt(3) + 1;
            GeneralizedShape shownShape = new GeneralizedShape(shownType, shownColor, shownPattern, shownNumber);

            mShownShapes.add(shownShape);

            // Generate dissimilar shape
            BriteHealthShape.ShapeType dissimilarType;
            BriteHealthShape.ShapeColor dissimilarColor;
            BriteHealthShape.ShapePattern dissimilarPattern;
            int dissimilarNumber;

            do {
                dissimilarType = BriteHealthShape.ShapeType.getRandom();
            } while (dissimilarType.equals(shownType));

            do {
                dissimilarColor = BriteHealthShape.ShapeColor.getRandom();
            } while (dissimilarColor.equals(shownColor));

            do {
                dissimilarPattern = BriteHealthShape.ShapePattern.getRandom();
            } while (dissimilarPattern.equals(shownPattern));

            do {
                dissimilarNumber = random.nextInt(3) + 1;
            } while (dissimilarNumber == shownNumber);

            GeneralizedShape dissimilarShape = new GeneralizedShape(
                    dissimilarType, dissimilarColor, dissimilarPattern, dissimilarNumber
            );

            dissimilarShape.setId(10);

            // Generate first similar shape

            do {
                dissimilarColor = BriteHealthShape.ShapeColor.getRandom();
            } while (dissimilarColor.equals(shownColor));

            do {
                dissimilarPattern = BriteHealthShape.ShapePattern.getRandom();
            } while (dissimilarPattern.equals(shownPattern));

            do {
                dissimilarNumber = random.nextInt(3) + 1;
            } while (dissimilarNumber == shownNumber);

            GeneralizedShape firstSimilarShape = new GeneralizedShape(
                    shownType, dissimilarColor, dissimilarPattern, dissimilarNumber
            );

            firstSimilarShape.setId(20);

            // Generate second similar shape

            do {
                dissimilarType = BriteHealthShape.ShapeType.getRandom();
            } while (dissimilarType.equals(shownType));

            do {
                dissimilarPattern = BriteHealthShape.ShapePattern.getRandom();
            } while (dissimilarPattern.equals(shownPattern));

            do {
                dissimilarNumber = random.nextInt(3) + 1;
            } while (dissimilarNumber == shownNumber);

            GeneralizedShape secondSimilarShape = new GeneralizedShape(
                    dissimilarType, shownColor, dissimilarPattern, dissimilarNumber
            );

            secondSimilarShape.setId(30);

            mTestTrials.add(
                    new TestTrial(dissimilarShape, firstSimilarShape, secondSimilarShape)
            );

        }

        testModel.setNumTrials(NUM_TRIALS);
        setTestModel(testModel);

        super.createTest();

    }

    @Override
    public BaseTestScores computeBasicTestScores() {

        TestScores testScores = new TestScores();
        testScores.setScore(getTestModel().getNumCorrect() * 10);
        return testScores;

    }

}
