package co.britehealth.android.assessment.dissimilar.shapes;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

import java.util.Date;


public class TestData implements Parcelable {

    @SerializedName("start")
    private Date mStartDate;

    @SerializedName("end")
    private Date mFinishDate;

    @SerializedName("processing_time")
    private long mProcessingTime;

    @SerializedName("is_correct")
    private int mCorrect;

    public TestData(Date startDate, Date finishDate, long processingTime, int correct) {

        this.mStartDate = startDate;
        this.mFinishDate = finishDate;
        this.mProcessingTime = processingTime;
        this.mCorrect = correct;

    }

    public void setStartDate(Date startDate) {
        this.mStartDate = startDate;
    }

    public void setFinishDate(Date finishDate) {
        this.mFinishDate = finishDate;
    }

    public void setProcessingTime(long processingTime) {
        this.mProcessingTime = processingTime;
    }

    public void setCorrect(int correct) {
        this.mCorrect = correct;
    }

    public Date getmStartDate() {
        return mStartDate;
    }

    public Date getmFinishDate() {
        return mFinishDate;
    }

    public long getmProcessingTime() {
        return mProcessingTime;
    }

    public int ismCorrect() {
        return mCorrect;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeLong(mStartDate.getTime());
        dest.writeLong(mFinishDate.getTime());
        dest.writeLong(mProcessingTime);
        dest.writeInt(mCorrect);

    }

    public static final Creator<TestData> CREATOR = new Creator<TestData>() {

        @Override
        public TestData createFromParcel(Parcel source) {
            return new TestData(source);
        }

        @Override
        public TestData[] newArray(int size) {
            return new TestData[size];
        }

    };

    public TestData(Parcel source) {

        mStartDate = new Date(source.readLong());
        mFinishDate = new Date(source.readLong());
        mProcessingTime = source.readLong();
        mCorrect = source.readInt();

    }

}
