package co.britehealth.android.assessment.dissimilar.shapes;

import android.os.Parcel;
import android.os.Parcelable;

import co.britehealth.android.assessment.common.BriteHealthShape.ShapeColor;
import co.britehealth.android.assessment.common.BriteHealthShape.ShapePattern;
import co.britehealth.android.assessment.common.BriteHealthShape.ShapeType;


public class GeneralizedShape implements Parcelable {

    private ShapeType mType;
    private ShapeColor mColor;
    private ShapePattern mPattern;
    private int mNumber;
    private int mId;

    public GeneralizedShape(ShapeType mType, ShapeColor mColor, ShapePattern mPattern, int mNumber) {
        this.mType = mType;
        this.mColor = mColor;
        this.mPattern = mPattern;
        this.mNumber = mNumber;
    }

    public void setId(int id) {
        mId = id;
    }

    public ShapeType getType() {
        return mType;
    }

    public ShapeColor getColor() {
        return mColor;
    }

    public ShapePattern getPattern() {
        return mPattern;
    }

    public int getNumber() {
        return mNumber;
    }

    public int getId() {
        return mId;
    }

    /* Parcelable */

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeSerializable(mType);
        dest.writeSerializable(mColor);
        dest.writeSerializable(mPattern);
        dest.writeInt(mNumber);
        dest.writeInt(mId);

    }

    public static final Creator<GeneralizedShape> CREATOR = new Creator<GeneralizedShape>() {

        @Override
        public GeneralizedShape createFromParcel(Parcel source) {
            return new GeneralizedShape(source);
        }

        @Override
        public GeneralizedShape[] newArray(int size) {
            return new GeneralizedShape[size];
        }

    };

    private GeneralizedShape(Parcel parcel) {

        mType = (ShapeType) parcel.readSerializable();
        mColor = (ShapeColor) parcel.readSerializable();
        mPattern = (ShapePattern) parcel.readSerializable();
        mNumber = parcel.readInt();
        mId = parcel.readInt();

    }

    /* End of Parcelable */

}
