package co.britehealth.android.assessment.common;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

import co.britehealth.android.R;


public class ScoreProgressBar extends View {

    private int mScore;
    private Paint mBackgroundPaint;
    private Paint mProgressPaint;

    public ScoreProgressBar(Context context) {

        super(context);
        initialize();

    }

    public ScoreProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScoreProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {

        super(context, attrs, defStyleAttr);
        initialize();

    }

    @Override
    protected void onDraw(Canvas canvas) {

        super.onDraw(canvas);

        int width = getWidth();
        int height = getHeight();

        canvas.drawRect(0, 0, width, height, mBackgroundPaint);
        canvas.drawRect(0, 0, width * (mScore / 100f), height, mProgressPaint);

    }

    public void setScore(int score) {

        mScore = score;
        invalidate();

    }

    private void initialize() {

        mBackgroundPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mBackgroundPaint.setColor(Color.BLACK);

        mProgressPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mProgressPaint.setColor(getResources().getColor(R.color.co_britehealth_android_primary_brite_health));

    }

    public void setProgressBarBackgroundColor(int backgroundColor) {

        mBackgroundPaint.setColor(backgroundColor);
        invalidate();

    }

}
