package co.britehealth.android.assessment.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

import co.britehealth.android.R;


public class ResponseView extends View {

    public static final int CORRECT = 0;
    public static final int WRONG = 1;

    private Paint mCorrectPaint;
    private Bitmap mCorrectBitmap;
    private Paint mWrongPaint;
    private Bitmap mWrongBitmap;
    private int mType;

    private float mRadius;

    public ResponseView(Context context) {

        super(context);
        initialize();

    }

    public ResponseView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ResponseView(Context context, AttributeSet attrs, int defStyleAttr) {

        super(context, attrs, defStyleAttr);
        initialize();

    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {

        mRadius = (Math.min(w, h)) / 2;
        mCorrectBitmap = Bitmap.createScaledBitmap(mCorrectBitmap, (int) mRadius, (int) mRadius, false);
        mWrongBitmap = Bitmap.createScaledBitmap(mWrongBitmap, (int) mRadius, (int) mRadius, false);

        super.onSizeChanged(w, h, oldw, oldh);

    }

    @Override
    protected void onDraw(Canvas canvas) {

        super.onDraw(canvas);

        Paint paint;
        Bitmap bitmap;

        switch (mType) {

            case WRONG: {

                paint = mWrongPaint;
                bitmap = mWrongBitmap;

                break;

            }

            default: {

                paint = mCorrectPaint;
                bitmap = mCorrectBitmap;

                break;

            }

        }

        canvas.drawCircle(
                getWidth() / 2,
                getHeight() / 2,
                mRadius,
                paint
        );

        canvas.drawBitmap(
                bitmap,
                (getWidth() / 2) - (bitmap.getWidth() / 2),
                (getHeight() / 2) - (bitmap.getHeight() / 2),
                paint
        );

    }

    private void initialize() {

        mCorrectPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mCorrectPaint.setStyle(Paint.Style.FILL);
        mCorrectPaint.setColor(getResources().getColor(R.color.brite_health_stroop_green));
        mCorrectBitmap = BitmapFactory.decodeResource(getResources(), R.drawable.co_britehealth_android_check_white);

        mWrongPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mWrongPaint.setStyle(Paint.Style.FILL);
        mWrongPaint.setColor(getResources().getColor(R.color.brite_health_stroop_red));
        mWrongBitmap = BitmapFactory.decodeResource(getResources(), R.drawable.co_britehealth_android_x_white);

    }

    public void setType(int type) {

        mType = type;
        invalidate();

    }

    public int getType() {
        return mType;
    }

}
