package co.britehealth.android.assessment.common;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import co.britehealth.android.R;
import fr.tvbarthel.lib.blurdialogfragment.SupportBlurDialogFragment;


public class PauseScreenFragment extends SupportBlurDialogFragment {

    private PauseScreenListener mListener;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setStyle(DialogFragment.STYLE_NO_TITLE, R.style.co_britehealth_android_pause_dialog);

    }

    @Override
    protected float getDownScaleFactor() {
        return 20.0f;
    }

    @Override
    protected int getBlurRadius() {
        return 10;
    }

    @Override
    protected boolean isActionBarBlurred() {
        return true;
    }

    @Override
    protected boolean isDimmingEnable() {
        return true;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_pause_screen, container, false);

        CardView mResumeButton = (CardView) rootView.findViewById(R.id.co_britehealth_android_resume_button);
        mResumeButton.setCardBackgroundColor(getResources().getColor(R.color.co_britehealth_android_orange_dark));
        mResumeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onResumeClick();
            }
        });

        CardView mTutorialButton = (CardView) rootView.findViewById(R.id.co_britehealth_android_tutorial_button);
        mTutorialButton.setCardBackgroundColor(getResources().getColor(R.color.co_britehealth_android_orange_dark));
        mTutorialButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onTutorialClick();
            }
        });

        CardView mRestartButton;
        if (getArguments().getInt("NUM_RESTARTS") == 0) {

            mRestartButton = (CardView) rootView.findViewById(R.id.co_britehealth_android_restart_button);
            mRestartButton.setCardBackgroundColor(getResources().getColor(R.color.co_britehealth_android_orange_dark));
            mRestartButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mListener.onRestartClick();
                }
            });

        } else {

            mRestartButton = (CardView) rootView.findViewById(R.id.co_britehealth_android_restart_button);
            mRestartButton.setCardBackgroundColor(getResources().getColor(R.color.co_britehealth_android_orange_dark));
            TextView textView = (TextView) mRestartButton.findViewById(R.id.co_britehealth_android_restart_textView);
            TextView textView1 = (TextView) mRestartButton.findViewById(R.id.co_britehealth_android_restart_once_textView);
            textView.setTextColor(getResources().getColor(R.color.material_blue_grey_800));
            textView1.setTextColor(getResources().getColor(R.color.material_blue_grey_800));
            mRestartButton.setEnabled(false);

        }

        CardView mQuitButton = (CardView) rootView.findViewById(R.id.co_britehealth_android_quit_button);
        mQuitButton.setCardBackgroundColor(getResources().getColor(R.color.co_britehealth_android_orange_dark));
        mQuitButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onQuitClick();
            }
        });

        return rootView;

    }

    public void setPauseScreenListener(PauseScreenListener listener) {
        mListener = listener;
    }

}
