package co.britehealth.android.assessment.common;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

import co.britehealth.android.R;


public class DotsProgressBar extends View {

    private Paint mDefaultPaint;
    private Paint mCurrentPaint;
    private int mSize;
    private int mCurrent;

    public DotsProgressBar(Context context) {

        super(context);
        initialize();

    }

    public DotsProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DotsProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {

        super(context, attrs, defStyleAttr);
        initialize();

    }

    @Override
    protected void onDraw(Canvas canvas) {

        super.onDraw(canvas);

        float cellSize = getWidth() / (mSize + 1);

        for (int i = 0; i < mSize; i++) {

            canvas.drawCircle(
                    (i + 1) * cellSize,
                    getHeight() / 2,
                    getHeight() / 2,
                    mDefaultPaint
            );

        }

        canvas.drawCircle(
                mCurrent * cellSize,
                getHeight() / 2,
                getHeight() / 2,
                mCurrentPaint
        );

    }

    public void setSize(int size) {
        mSize = size;
    }

    public void setCurrent(int current) {

        mCurrent = current;
        invalidate();

    }

    private void initialize() {

        mDefaultPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mDefaultPaint.setColor(Color.BLACK);

        mCurrentPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
        mCurrentPaint.setColor(getResources().getColor(R.color.co_britehealth_android_orange_dark));

    }

}
