package co.britehealth.android.assessment.common;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;


public class BriteHealthViewPager extends ViewPager {

    private boolean mEnabled;

    public BriteHealthViewPager(Context context) {

        super(context);
        mEnabled = true;

    }

    public BriteHealthViewPager(Context context, AttributeSet attrs) {

        super(context, attrs);
        mEnabled = true;

    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        return mEnabled && super.onTouchEvent(ev);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return mEnabled && super.onInterceptTouchEvent(ev);
    }

    @Override
    public boolean isEnabled() {
        return mEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        mEnabled = enabled;
    }

}
