package co.britehealth.android.assessment;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v7.app.AppCompatActivity;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;
import java.util.List;

import co.britehealth.android.R;
import co.britehealth.android.assessment.common.BriteHealthViewPager;


public class BriteHealthAssessmentActivity extends AppCompatActivity {

    private BriteHealthViewPager mViewPager;
    private ScreenSlidePagerAdapter mAdapter;

    private Tracker mTracker;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.co_britehealth_android_activity_assessments);

        mViewPager = (BriteHealthViewPager) findViewById(R.id.co_britehealth_android_view_pager);
        mAdapter = new ScreenSlidePagerAdapter(getSupportFragmentManager());
        mViewPager.setAdapter(mAdapter);

    }

    @Override
    public void onBackPressed() {

    }

    public BriteHealthViewPager getViewPager() {
        return mViewPager;
    }

    public ScreenSlidePagerAdapter getAdapter() {
        return mAdapter;
    }

    public void showIntroduction(int position) {
        mViewPager.setCurrentItem(position);
    }

    public class ScreenSlidePagerAdapter extends FragmentStatePagerAdapter {

        private static final int NUM_FRAGMENTS = 5;
        private List<Fragment> mFragmentList;

        public ScreenSlidePagerAdapter(FragmentManager fm) {

            super(fm);

            mFragmentList = new ArrayList<>();
            mFragmentList.add(new co.britehealth.android.assessment.stroop.Introduction());
            mFragmentList.add(new co.britehealth.android.assessment.tmt.Introduction());
            mFragmentList.add(new co.britehealth.android.assessment.shape.recall.Introduction());
            mFragmentList.add(new co.britehealth.android.assessment.dsst.Introduction());
            mFragmentList.add(new co.britehealth.android.assessment.dissimilar.shapes.Introduction());

        }

        @Override
        public Fragment getItem(int position) {
            return mFragmentList.get(position);
        }

        @Override
        public int getCount() {
            return NUM_FRAGMENTS;
        }

        public List<Fragment> getFragmentList() {
            return mFragmentList;
        }

    }

    synchronized public Tracker getDefaultTracker() {

        if (mTracker == null) {

            GoogleAnalytics googleAnalytics = GoogleAnalytics.getInstance(this);
            mTracker = googleAnalytics.newTracker(R.xml.analytics_global_brite_health);

        }

        return mTracker;

    }

}
