package co.britehealth.android.analytics;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import co.britehealth.android.R;
import co.britehealth.android.assessment.common.ScoreProgressBar;
import co.britehealth.android.assessment.tmt.TestManager;
import co.britehealth.android.model.data.DBContract;


public class SupportIndividualAnalyticsFragment extends Fragment {

    private static final String SCREEN_NAME = SupportIndividualAnalyticsFragment.class.getSimpleName();
    private Tracker mTracker;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        mTracker = getDefaultTracker();

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_analytics_individual, container, false);

        int totalScore = 0;

        Cursor cursor = getActivity()
                .getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"1"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );


        int lastScore1 = 0;

        if (cursor.moveToFirst()) {

            lastScore1 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        ScoreProgressBar scoreProgressBar1 =
                (ScoreProgressBar) rootView.findViewById(R.id.co_britehealth_android_analytics_stroop);
        TextView textView1 = (TextView) rootView.findViewById(R.id.co_britehealth_android_analytics_stroop_text);

        scoreProgressBar1.setProgressBarBackgroundColor(Color.LTGRAY);
        scoreProgressBar1.setScore(lastScore1);
        textView1.setText(String.valueOf(lastScore1));
        totalScore = totalScore + lastScore1;

        cursor = getActivity()
                .getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"2"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );

        int lastScore2 = 0;

        if (cursor.moveToFirst()) {

            lastScore2 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        ScoreProgressBar scoreProgressBar2 =
                (ScoreProgressBar) rootView.findViewById(R.id.co_britehealth_android_analytics_tmt);
        TextView textView2 = (TextView) rootView.findViewById(R.id.co_britehealth_android_analytics_tmt_text);

        scoreProgressBar2.setProgressBarBackgroundColor(Color.LTGRAY);
        scoreProgressBar2.setScore(lastScore2);
        textView2.setText(String.valueOf(lastScore2));
        totalScore = totalScore + lastScore2;

        cursor = getActivity()
                .getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"3"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );

        int lastScore3 = 0;

        if (cursor.moveToFirst()) {

            lastScore3 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        ScoreProgressBar scoreProgressBar3 =
                (ScoreProgressBar) rootView.findViewById(R.id.co_britehealth_android_analytics_shape_recall);
        TextView textView3 = (TextView) rootView.findViewById(R.id.co_britehealth_android_analytics_shape_recall_text);

        scoreProgressBar3.setProgressBarBackgroundColor(Color.LTGRAY);
        scoreProgressBar3.setScore(lastScore3);
        textView3.setText(String.valueOf(lastScore3));
        totalScore = totalScore + lastScore3;

        cursor = getActivity()
                .getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"4"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );

        int lastScore4 = 0;

        if (cursor.moveToFirst()) {

            lastScore4 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        ScoreProgressBar scoreProgressBar4 =
                (ScoreProgressBar) rootView.findViewById(R.id.co_britehealth_android_analytics_dsst);
        TextView textView4 = (TextView) rootView.findViewById(R.id.co_britehealth_android_analytics_dsst_text);

        scoreProgressBar4.setProgressBarBackgroundColor(Color.LTGRAY);
        scoreProgressBar4.setScore(lastScore4);
        textView4.setText(String.valueOf(lastScore4));
        totalScore = totalScore + lastScore4;

        cursor = getActivity()
                .getContentResolver()
                .query(
                        DBContract.NextAssessmentTimesTable.CONTENT_URI,
                        null,
                        DBContract.NextAssessmentTimesTable._ID + " = ?",
                        new String[]{"5"},
                        DBContract.NextAssessmentTimesTable._ID + " ASC"
                );

        int lastScore5 = 0;

        if (cursor.moveToFirst()) {

            lastScore5 = cursor.getInt(
                    cursor.getColumnIndex(DBContract.NextAssessmentTimesTable.COLUMN_SCORE)
            );

        }

        ScoreProgressBar scoreProgressBar5 =
                (ScoreProgressBar) rootView.findViewById(R.id.co_britehealth_android_analytics_dissimilar_shapes);
        TextView textView5 = (TextView) rootView.findViewById(R.id.co_britehealth_android_analytics_dissimilar_shapes_text);

        scoreProgressBar5.setProgressBarBackgroundColor(Color.LTGRAY);
        scoreProgressBar5.setScore(lastScore5);
        textView5.setText(String.valueOf(lastScore5));
        totalScore = totalScore + lastScore5;

        cursor.close();

        totalScore = totalScore / 5;

        ((TextView) rootView.findViewById(R.id.co_britehealth_android_total_score_textView)).setText(
                "TOTAL SCORE: " + totalScore
        );

        ScoreProgressBar scoreProgressBar6 =
                (ScoreProgressBar) rootView.findViewById(R.id.co_britehealth_android_analytics_ef);
        TextView textView6 = (TextView) rootView.findViewById(R.id.co_britehealth_android_analytics_ef_text);
        scoreProgressBar6.setProgressBarBackgroundColor(Color.LTGRAY);
        scoreProgressBar6.setScore((lastScore1 + lastScore2) / 2);
        textView6.setText(String.valueOf((lastScore1 + lastScore2) / 2));

        ScoreProgressBar scoreProgressBar7 =
                (ScoreProgressBar) rootView.findViewById(R.id.co_britehealth_android_analytics_m);
        TextView textView7 = (TextView) rootView.findViewById(R.id.co_britehealth_android_analytics_m_text);
        scoreProgressBar7.setProgressBarBackgroundColor(Color.LTGRAY);
        scoreProgressBar7.setScore((lastScore3 + lastScore5) / 2);
        textView7.setText(String.valueOf((lastScore3 + lastScore5) / 2));

        ScoreProgressBar scoreProgressBar8 =
                (ScoreProgressBar) rootView.findViewById(R.id.co_britehealth_android_analytics_ps);
        TextView textView8 = (TextView) rootView.findViewById(R.id.co_britehealth_android_analytics_ps_text);
        scoreProgressBar8.setProgressBarBackgroundColor(Color.LTGRAY);

        float tmtA = getActivity().getSharedPreferences(TestManager.TMT_A_SCORE, Context.MODE_PRIVATE)
                .getFloat(TestManager.TMT_A_SCORE, 0);

        float score8 = ((3f * lastScore4) + tmtA) / 4f;

        scoreProgressBar8.setScore((int) score8);
        textView8.setText(String.valueOf((int) score8));

        return rootView;

    }

    @Override
    public void onPause() {

        super.onPause();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

    }

    synchronized public Tracker getDefaultTracker() {

        if (mTracker == null) {

            GoogleAnalytics googleAnalytics = GoogleAnalytics.getInstance(getActivity());
            mTracker = googleAnalytics.newTracker(R.xml.analytics_global_brite_health);

        }

        return mTracker;

    }

}
