package co.britehealth.android.analytics;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;

import co.britehealth.android.R;


public class ComparativeAnalyticsHuman extends View {

    private int mPercentage;
    private Bitmap mHumanBitmap;
    private Bitmap mBlueHumanBitmap;

    public ComparativeAnalyticsHuman(Context context) {

        super(context);
        initialize();

    }

    public ComparativeAnalyticsHuman(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ComparativeAnalyticsHuman(Context context, AttributeSet attrs, int defStyleAttr) {

        super(context, attrs, defStyleAttr);
        initialize();

    }

    @Override
    protected void onDraw(Canvas canvas) {

        super.onDraw(canvas);

        float cellLength = getWidth() / 12;

        float top = (getHeight() - mBlueHumanBitmap.getHeight()) / 2f;

        for (int i = 0; i < (mPercentage / 10); i++) {

            canvas.drawBitmap(
                    mBlueHumanBitmap,
                    (i + 1) * cellLength,
                    top,
                    null
            );

        }

        if ((mPercentage % 10) == 0) {

            if (mPercentage <= 90) {

                for (int i = 0; i < (100 - mPercentage) / 10; i++) {
                    canvas.drawBitmap(
                            mHumanBitmap,
                            ((mPercentage / 10) + i + 1) * cellLength,
                            top,
                            null
                    );

                }

            }

        } else {

            canvas.drawBitmap(getPartialHuman(), ((mPercentage / 10) + 1) * cellLength, top, null);

            if (mPercentage <= 90) {

                for (int i = 0; i < (100 - mPercentage) / 10; i++) {
                    canvas.drawBitmap(
                            mHumanBitmap,
                            ((mPercentage / 10) + i + 2) * cellLength,
                            top,
                            null
                    );

                }

            }

        }

    }

    public void setPercentage(int percentage) {

        mPercentage = Math.max(0, percentage);
        invalidate();

    }

    private void initialize() {

        mPercentage = 1;

        mHumanBitmap = BitmapFactory.decodeResource(getResources(), R.drawable.co_britehealth_android_compare_human);
        mBlueHumanBitmap =
                BitmapFactory.decodeResource(getResources(), R.drawable.co_britehealth_android_compare_human_blue);

    }

    private Bitmap getPartialHuman() {

        int divide = mPercentage % 10;

        Bitmap bitmap = BitmapFactory.decodeResource(getResources(), R.drawable.co_britehealth_android_compare_human);
        bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);

        int width = bitmap.getWidth();
        int height = bitmap.getHeight();

        int[] ints = new int[width * height];

        bitmap.getPixels(ints, 0, width, 0, 0, divide * (width / 10), height);

        int gray = getResources().getColor(R.color.co_britehealth_android_humans);
        int blue = getResources().getColor(R.color.brite_health_stroop_blue);

        for (int i = 0; i < ints.length; i++) {

            if (ints[i] == gray) {
                ints[i] = blue;
            }

        }

        bitmap.setPixels(ints, 0, width, 0, 0, divide * (width / 10), height);

        return bitmap;

    }

}
