package co.britehealth.android.analytics;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.content.LocalBroadcastManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.util.ArrayList;
import java.util.List;

import co.britehealth.android.BriteHealthSdk;
import co.britehealth.android.R;
import co.britehealth.android.service.ComparativeAnalyticsService;


@TargetApi(Build.VERSION_CODES.HONEYCOMB)
public class ComparativeAnalyticsFragment extends Fragment implements TabLayout.OnTabSelectedListener {

    private static final String SCREEN_NAME = ComparativeAnalyticsFragment.class.getSimpleName();
    private Tracker mTracker;

    private List<ComparativeAnalyticsHuman> mHumanList;
    private List<TextView> mTextViewList;

    private ProgressBar mProgressBarTotal;
    private ProgressBar mProgressBarTabs;

    private LinearLayout linearLayoutTotal;
    private LinearLayout linearLayoutTabs;

    private SupportComparativeAnalyticsReceiver mSupportComparativeAnalyticsReceiver;

    private Bundle mBundle;
    private TabLayout mTabLayout;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        mTracker = getDefaultTracker();

        mSupportComparativeAnalyticsReceiver = new SupportComparativeAnalyticsReceiver();

        LocalBroadcastManager
                .getInstance(getActivity())
                .registerReceiver(
                        mSupportComparativeAnalyticsReceiver,
                        new IntentFilter(ComparativeAnalyticsService.ACTION)
                );

        Intent intent = new Intent(getActivity(), ComparativeAnalyticsService.class);
        intent.putExtra(BriteHealthSdk.EXTRA_API_KEY, getArguments().getString(BriteHealthSdk.EXTRA_API_KEY));
        intent.putExtra(BriteHealthSdk.EXTRA_DATA_SECRET, getArguments().getString(BriteHealthSdk.EXTRA_DATA_SECRET));
        getActivity().startService(intent);

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.co_britehealth_android_analytics_comparative, container, false);
        mTabLayout = (TabLayout) rootView.findViewById(R.id.co_britehealth_android_tab_layout);
        mTabLayout.addTab(mTabLayout.newTab().setText("EXECUTIVE FUNCTIONS"));
        mTabLayout.addTab(mTabLayout.newTab().setText("MEMORY"));
        mTabLayout.addTab(mTabLayout.newTab().setText("PROCESSING SPEED"));

        mProgressBarTotal = (ProgressBar) rootView.findViewById(R.id.co_britehealth_android_progress_bar_1);
        mProgressBarTabs = (ProgressBar) rootView.findViewById(R.id.co_britehealth_android_progress_bar_2);

        linearLayoutTotal = (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_linear_one);
        linearLayoutTabs = (LinearLayout) rootView.findViewById(R.id.co_britehealth_android_linear_two);

        mHumanList = new ArrayList<>();
        mHumanList.add((ComparativeAnalyticsHuman) rootView.findViewById(R.id.co_britehealth_android_human_one));
        mHumanList.add((ComparativeAnalyticsHuman) rootView.findViewById(R.id.co_britehealth_android_human_two));
        mHumanList.add((ComparativeAnalyticsHuman) rootView.findViewById(R.id.co_britehealth_android_human_three));
        mHumanList.add((ComparativeAnalyticsHuman) rootView.findViewById(R.id.co_britehealth_android_human_four));
        mHumanList.add((ComparativeAnalyticsHuman) rootView.findViewById(R.id.co_britehealth_android_human_one_tab));
        mHumanList.add((ComparativeAnalyticsHuman) rootView.findViewById(R.id.co_britehealth_android_human_two_tab));
        mHumanList.add((ComparativeAnalyticsHuman) rootView.findViewById(R.id.co_britehealth_android_human_three_tab));
        mHumanList.add((ComparativeAnalyticsHuman) rootView.findViewById(R.id.co_britehealth_android_human_four_tab));

        mTextViewList = new ArrayList<>();
        mTextViewList.add((TextView) rootView.findViewById(R.id.co_britehealth_android_text_one));
        mTextViewList.add((TextView) rootView.findViewById(R.id.co_britehealth_android_text_two));
        mTextViewList.add((TextView) rootView.findViewById(R.id.co_britehealth_android_text_three));
        mTextViewList.add((TextView) rootView.findViewById(R.id.co_britehealth_android_text_four));
        mTextViewList.add((TextView) rootView.findViewById(R.id.co_britehealth_android_text_one_tab));
        mTextViewList.add((TextView) rootView.findViewById(R.id.co_britehealth_android_text_two_tab));
        mTextViewList.add((TextView) rootView.findViewById(R.id.co_britehealth_android_text_three_tab));
        mTextViewList.add((TextView) rootView.findViewById(R.id.co_britehealth_android_text_four_tab));

        return rootView;

    }

    @Override
    public void onResume() {

        super.onResume();

        mTracker.setScreenName(SCREEN_NAME);
        mTracker.send(new HitBuilders.ScreenViewBuilder().build());

    }

    @Override
    public void onTabSelected(TabLayout.Tab tab) {

        switch (tab.getPosition()) {

            case 0: {

                mHumanList.get(4).setPercentage(mBundle.getInt("five"));
                mTextViewList.get(4).setText(getHumanText(mBundle.getInt("five")));

                mHumanList.get(5).setPercentage(mBundle.getInt("six"));
                mTextViewList.get(5).setText(getHumanText(mBundle.getInt("six")));

                mHumanList.get(6).setPercentage(mBundle.getInt("seven"));
                mTextViewList.get(6).setText(getHumanText(mBundle.getInt("seven")));

                mHumanList.get(7).setPercentage(mBundle.getInt("eight"));
                mTextViewList.get(7).setText(getHumanText(mBundle.getInt("eight")));

                break;

            }

            case 1: {

                mHumanList.get(4).setPercentage(mBundle.getInt("nine"));
                mTextViewList.get(4).setText(getHumanText(mBundle.getInt("nine")));

                mHumanList.get(5).setPercentage(mBundle.getInt("ten"));
                mTextViewList.get(5).setText(getHumanText(mBundle.getInt("ten")));

                mHumanList.get(6).setPercentage(mBundle.getInt("eleven"));
                mTextViewList.get(6).setText(getHumanText(mBundle.getInt("eleven")));

                mHumanList.get(7).setPercentage(mBundle.getInt("twelve"));
                mTextViewList.get(7).setText(getHumanText(mBundle.getInt("twelve")));

                break;

            }

            case 2: {

                mHumanList.get(4).setPercentage(mBundle.getInt("thirteen"));
                mTextViewList.get(4).setText(getHumanText(mBundle.getInt("thirteen")));

                mHumanList.get(5).setPercentage(mBundle.getInt("fourteen"));
                mTextViewList.get(5).setText(getHumanText(mBundle.getInt("fourteen")));

                mHumanList.get(6).setPercentage(mBundle.getInt("fifteen"));
                mTextViewList.get(6).setText(getHumanText(mBundle.getInt("fifteen")));

                mHumanList.get(7).setPercentage(mBundle.getInt("sixteen"));
                mTextViewList.get(7).setText(getHumanText(mBundle.getInt("sixteen")));

                break;

            }

        }

    }

    @Override
    public void onTabUnselected(TabLayout.Tab tab) {

    }

    @Override
    public void onTabReselected(TabLayout.Tab tab) {

    }

    private final class SupportComparativeAnalyticsReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {

            mProgressBarTotal.setVisibility(View.GONE);
            mProgressBarTabs.setVisibility(View.GONE);

            boolean successful = intent.getBooleanExtra(ComparativeAnalyticsService.SUCCESSFUL, false);

            if (successful) {

                mTabLayout.setOnTabSelectedListener(ComparativeAnalyticsFragment.this);

                linearLayoutTotal.setVisibility(View.VISIBLE);
                linearLayoutTabs.setVisibility(View.VISIBLE);

                mBundle = intent.getBundleExtra(ComparativeAnalyticsService.PERCENTILES);

                mHumanList.get(0).setPercentage(mBundle.getInt("one"));
                mTextViewList.get(0).setText(getHumanText(mBundle.getInt("one")));

                mHumanList.get(1).setPercentage(mBundle.getInt("two"));
                mTextViewList.get(1).setText(getHumanText(mBundle.getInt("two")));

                mHumanList.get(2).setPercentage(mBundle.getInt("three"));
                mTextViewList.get(2).setText(getHumanText(mBundle.getInt("three")));

                mHumanList.get(3).setPercentage(mBundle.getInt("four"));
                mTextViewList.get(3).setText(getHumanText(mBundle.getInt("four")));

                mHumanList.get(4).setPercentage(mBundle.getInt("five"));
                mTextViewList.get(4).setText(getHumanText(mBundle.getInt("five")));

                mHumanList.get(5).setPercentage(mBundle.getInt("six"));
                mTextViewList.get(5).setText(getHumanText(mBundle.getInt("six")));

                mHumanList.get(6).setPercentage(mBundle.getInt("seven"));
                mTextViewList.get(6).setText(getHumanText(mBundle.getInt("seven")));

                mHumanList.get(7).setPercentage(mBundle.getInt("eight"));
                mTextViewList.get(7).setText(getHumanText(mBundle.getInt("eight")));

            } else {

                Toast.makeText(getActivity(), "Update failed. Try again.", Toast.LENGTH_SHORT).show();

            }

            LocalBroadcastManager
                    .getInstance(getActivity())
                    .unregisterReceiver(mSupportComparativeAnalyticsReceiver);

        }

    }

    synchronized public Tracker getDefaultTracker() {

        if (mTracker == null) {

            GoogleAnalytics googleAnalytics = GoogleAnalytics.getInstance(getActivity());
            mTracker = googleAnalytics.newTracker(R.xml.analytics_global_brite_health);

        }

        return mTracker;

    }

    private String getHumanText(int n) {

        String returnString;

        if (n == 0) {
            returnString = "NA";
        } else {
            returnString = n + "%";
        }

        return returnString;

    }

}
