package co.britehealth.android;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.SerializedName;

import java.util.Date;


/**
 * A data class representing a Brite Health fitness activity.
 */
public class FitnessActivity implements Parcelable {

    @SerializedName("user_id")
    private int mUserId;

    @SerializedName("sample_type")
    private String mSampleType;

    @SerializedName("uuid")
    private String mUuid;

    @SerializedName("quantity_identifier")
    private String mQuantityIdentifier;

    @SerializedName("quantity_unit")
    private String mQuantityUnit;

    @SerializedName("quantity_value")
    private double mQuantityValue;

    @SerializedName("workout_type")
    private String mWorkoutType;

    @SerializedName("total_energy_burned_unit")
    private String mEnergyUnit;

    @SerializedName("total_energy_burned_value")
    private double mEnergyBurnedValue;

    @SerializedName("total_distance_unit")
    private String mDistanceUnit;

    @SerializedName("total_distance_value")
    private double mDistanceValue;

    @SerializedName("duration")
    private double mDuration;

    @SerializedName("start")
    private Date mStartDate;

    @SerializedName("end")
    private Date mFinishDate;

    public FitnessActivity(Builder builder) {

        mSampleType = builder.mSampleType.toString();
        mUuid = builder.mUuid;

        if (builder.mQuantityIdentifier != null) {
            mQuantityIdentifier = builder.mQuantityIdentifier.toString();
        }

        if (builder.mQuantityUnit != null) {
            mQuantityUnit = builder.mQuantityUnit.toString();
        }

        mQuantityValue = builder.mQuantityValue;

        if (builder.mWorkoutType != null) {
            mWorkoutType = builder.mWorkoutType.toString();
        }

        if (builder.mEnergyUnit != null) {
            mEnergyUnit = builder.mEnergyUnit.toString();
        }

        mEnergyBurnedValue = builder.mEnergyBurnedValue;

        if (builder.mDistanceUnit != null) {
            mDistanceUnit = builder.mDistanceUnit.toString();
        }

        mDistanceValue = builder.mDistanceValue;
        mDuration = builder.mDuration;
        mStartDate = builder.mStartDate;
        mFinishDate = builder.mFinishDate;

    }

    public void setUserId(int userId) {
        mUserId = userId;
    }

    public int getUserId() {
        return mUserId;
    }

    public String getSampleType() {
        return mSampleType;
    }

    public String getUuid() {
        return mUuid;
    }

    public String getQuantityIdentifier() {
        return mQuantityIdentifier;
    }

    public String getQuantityUnit() {
        return mQuantityUnit;
    }

    public double getQuantityValue() {
        return mQuantityValue;
    }

    public String getWorkoutType() {
        return mWorkoutType;
    }

    public String getEnergyUnit() {
        return mEnergyUnit;
    }

    public double getEnergyBurnedValue() {
        return mEnergyBurnedValue;
    }

    public String getDistanceUnit() {
        return mDistanceUnit;
    }

    public double getDistanceValue() {
        return mDistanceValue;
    }

    public double getDuration() {
        return mDuration;
    }

    public Date getStartDate() {
        return mStartDate;
    }

    public Date getFinishDate() {
        return mFinishDate;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {

        dest.writeInt(mUserId);
        dest.writeString(mSampleType);
        dest.writeString(mUuid);
        dest.writeString(mQuantityIdentifier);
        dest.writeString(mQuantityUnit);
        dest.writeDouble(mQuantityValue);
        dest.writeString(mWorkoutType);
        dest.writeString(mEnergyUnit);
        dest.writeDouble(mEnergyBurnedValue);
        dest.writeString(mDistanceUnit);
        dest.writeDouble(mDistanceValue);
        dest.writeDouble(mDuration);

        if (mStartDate != null) {
            dest.writeLong(mStartDate.getTime());
        } else {
            dest.writeLong(-1);
        }

        if (mFinishDate != null) {
            dest.writeLong(mFinishDate.getTime());
        } else {
            dest.writeLong(-1);
        }

    }

    public static final Creator<FitnessActivity> CREATOR = new Creator<FitnessActivity>() {

        @Override
        public FitnessActivity createFromParcel(Parcel source) {
            return new FitnessActivity(source);
        }

        @Override
        public FitnessActivity[] newArray(int size) {
            return new FitnessActivity[size];
        }

    };

    private FitnessActivity(Parcel parcel) {

        mUserId = parcel.readInt();
        mSampleType = parcel.readString();
        mUuid = parcel.readString();
        mQuantityIdentifier = parcel.readString();
        mQuantityUnit = parcel.readString();
        mQuantityValue = parcel.readDouble();
        mWorkoutType = parcel.readString();
        mEnergyUnit = parcel.readString();
        mEnergyBurnedValue = parcel.readDouble();
        mDistanceUnit = parcel.readString();
        mDistanceValue = parcel.readDouble();
        mDuration = parcel.readDouble();

        long timeOne = parcel.readLong();
        if (timeOne == -1) {
            mStartDate = null;
        } else {
            mStartDate = new Date(timeOne);
        }

        long timeTwo = parcel.readLong();
        if (timeTwo == -1) {
            mFinishDate = null;
        } else {
            mFinishDate = new Date(timeTwo);
        }

    }

    public static final class Builder {

        private SampleType mSampleType;
        private String mUuid;
        private QuantityIdentifier mQuantityIdentifier;
        private QuantityUnit mQuantityUnit;
        private double mQuantityValue;
        private WorkoutType mWorkoutType;
        private EnergyUnit mEnergyUnit;
        private double mEnergyBurnedValue;
        private DistanceUnit mDistanceUnit;
        private double mDistanceValue;
        private double mDuration;
        private Date mStartDate;
        private Date mFinishDate;

        public Builder(SampleType sampleType) {

            mSampleType = sampleType;

            mStartDate = new Date(System.currentTimeMillis());
            mFinishDate = new Date(System.currentTimeMillis());

        }

        public Builder setUuid(String uuid) {
            mUuid = uuid;
            return this;
        }

        public Builder setQuantityIdentifier(QuantityIdentifier quantityIdentifier) {
            mQuantityIdentifier = quantityIdentifier;
            return this;
        }

        public Builder setQuantityUnit(QuantityUnit quantityUnit) {
            mQuantityUnit = quantityUnit;
            return this;
        }

        public Builder setQuantityValue(double quantityValue) {
            mQuantityValue = quantityValue;
            return this;
        }

        public Builder setWorkoutType(WorkoutType workoutType) {
            mWorkoutType = workoutType;
            return this;
        }

        public Builder setEnergyUnit(EnergyUnit energyUnit) {
            mEnergyUnit = energyUnit;
            return this;
        }

        public Builder setEnergyBurnedValue(double energyBurnedValue) {
            mEnergyBurnedValue = energyBurnedValue;
            return this;
        }

        public Builder setDistanceUnit(DistanceUnit distanceUnit) {
            mDistanceUnit = distanceUnit;
            return this;
        }

        public Builder setDistanceValue(double distanceValue) {
            mDistanceValue = distanceValue;
            return this;
        }

        public Builder setDuration(double duration) {
            mDuration = duration;
            return this;
        }

        public Builder setStartDate(Date startDate) {
            mStartDate = startDate;
            return this;
        }

        public Builder setFinishDate(Date finishDate) {
            mFinishDate = finishDate;
            return this;
        }

        public FitnessActivity build() {
            return new FitnessActivity(this);
        }

    }

    public enum SampleType {

        QUANTITY_TYPE {
            @Override
            public String toString() {
                return "QuantityType";
            }
        },

        WORKOUT {
            @Override
            public String toString() {
                return "Workout";
            }
        }

    }

    public enum QuantityIdentifier {

        HEART_RATE {
            @Override
            public String toString() {
                return "HearthRate";
            }
        },

        HEIGHT {
            @Override
            public String toString() {
                return "Height";
            }
        },

        WEIGHT {
            @Override
            public String toString() {
                return "Weight";
            }
        }

    }

    public enum QuantityUnit {

        INCH {
            @Override
            public String toString() {
                return "in";
            }
        },

        POUND {
            @Override
            public String toString() {
                return "lb";
            }
        },

        COUNT_PER_MINUTE {
            @Override
            public String toString() {
                return "count/min";
            }
        },

    }

    public enum WorkoutType {

        AMERICAN_FOOTBALL {
            @Override
            public String toString() {
                return "AmericanFootball";
            }
        }

    }

    public enum EnergyUnit {

        CALORIES {
            @Override
            public String toString() {
                return "cal";
            }
        }

    }

    public enum DistanceUnit {

        MILES {
            @Override
            public String toString() {
                return "mi";
            }
        }

    }

}
