package co.britehealth.android;

import android.app.Activity;
import android.app.Fragment;

import java.util.ArrayList;

import co.britehealth.android.BriteHealthSdk.RegisterUserCallbacks;
import co.britehealth.android.BriteHealthSdk.ScoreCallbacks;
import co.britehealth.android.BriteHealthSdk.UserFitnessActivityCallbacks;


interface BriteHealthSdkInterface {

    void registerUser(BriteHealthUser briteHealthUser, RegisterUserCallbacks callbacks);
    void addUserFitnessActivity(FitnessActivity fitnessActivity, UserFitnessActivityCallbacks callbacks);
    void addUserFitnessActivity(ArrayList<FitnessActivity> fitnessActivities, UserFitnessActivityCallbacks callbacks);

    void getNextAssessmentTimes(BriteHealthSdk.NextAssessmentTimesCallbacks callbacks);
    void getScore(int start, int limit, long minTimestamp, long maxTimestamp, ScoreCallbacks callbacks);

    void launchAssessmentForResult(Activity activity, int requestCode);
    void launchAssessmentForResult(Fragment fragment, int requestCode);
    void launchAssessmentForResult(android.support.v4.app.Fragment supportFragment, int requestCode);

    Fragment getAnalyticsFragment(BriteHealthSdk.AnalyticsType analyticsType);
    android.support.v4.app.Fragment getSupportAnalyticsFragment(BriteHealthSdk.AnalyticsType analyticsType);

}
