package co.britehealth.android;


/**
 * Base class for all runtime exceptions thrown by the Brite Health SDK.
 */
public class BriteHealthException extends RuntimeException {

    private int mCode;

    public BriteHealthException() {
        super();
    }

    public BriteHealthException(String detailMessage) {
        super(detailMessage);
    }

    public BriteHealthException(int code, String detailMessage) {
        super(detailMessage);
        mCode = code;
    }

    public int getCode() {
        return mCode;
    }

}
