/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.maven.plugins.zip;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.zeroturnaround.zip.ZipUtil;

@Mojo(name="zip", defaultPhase=LifecyclePhase.PACKAGE)
public class ZipMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="inputDir")
    private File inputDirectory;
    @Parameter(defaultValue="${project.build.directory}", property="outputDir")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", property="zipName")
    private String zipName;

    public void execute() throws MojoExecutionException {
        boolean success;
        this.getLog().info((CharSequence)("Zipping content of directory [" + this.inputDirectory.getAbsolutePath() + "] to [" + this.outputDirectory.getAbsolutePath() + File.pathSeparator + this.zipName + "]"));
        if (!this.inputDirectory.exists()) {
            this.getLog().error((CharSequence)("Input directory [" + this.inputDirectory.getAbsolutePath() + "] does not exist!"));
            throw new MojoExecutionException("Input directory [" + this.inputDirectory.getAbsolutePath() + "] does not exist!");
        }
        if (!this.outputDirectory.exists() && !(success = this.outputDirectory.mkdirs())) {
            this.getLog().error((CharSequence)("Error while creating the output directory: " + this.outputDirectory.getAbsolutePath()));
            throw new MojoExecutionException("Error while creating the output directory: " + this.outputDirectory.getAbsolutePath());
        }
        File artifact = new File(this.outputDirectory, this.zipName + ".zip");
        ZipUtil.pack((File)this.inputDirectory, (File)artifact);
        this.project.getArtifact().setFile(artifact);
    }
}

